/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import oracle.javatools.db.Database;
import oracle.olap.actions.BaseRunnable;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;

public class NewAWRunnable
extends BaseRunnable {
    private Database db;
    private String awName;
    private String schemaName;
    private String tablespace;

    public NewAWRunnable(Database database, String string, String string2, String string3) {
        this.db = database;
        this.tablespace = string2;
        this.schemaName = string;
        this.awName = string3;
    }

    @Override
    public void run() {
        try {
            this.createAW();
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }

    private void createAW() throws Exception {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(this.db.getConnection());
        Schema schema = new Schema(this.schemaName);
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(this.schemaName)) {
            this.schemaName = String.format("\"%s\"", this.schemaName);
        }
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(this.awName)) {
            this.awName = String.format("\"%s\"", this.awName);
        }
        String string = "";
        if (this.tablespace != null) {
            if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(this.tablespace)) {
                this.tablespace = String.format("\"%s\"", this.tablespace);
            }
            string = " TABLESPACE " + this.tablespace;
        }
        String string2 = String.format("CREATE ANALYTIC WORKSPACE %s.%s%s", this.schemaName, this.awName, string);
        MetadataContext metadataContext = new MetadataContext(this.db, new CubeDDLStatements(string2));
        metadataContext.setSchema(schema);
        metadataContext.setDatabase(databaseImpl);
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        metadataXML.parse();
        metadataXML.executeSQL();
    }
}

