/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Element;
import oracle.olap.OLAPResources;
import oracle.olap.actions.MultipleExportXMLAction;
import oracle.olap.app.Resources;

public class MultipleObjectContextMenu
implements ContextMenuListener {
    final String CUBE = "CUBE";
    final String CALCMEASURE = "CALCMEASURE";
    final String CUBE_DIMENSION = "CUBE DIMENSION";
    final String MEASURE_FOLDER = "MEASURE FOLDER";
    final MultipleExportXMLAction _action = new MultipleExportXMLAction();
    List<DBObject> dbObjects;
    Resources resources = new OLAPResources();

    public void menuWillShow(ContextMenu contextMenu) {
        this.dbObjects = new ArrayList<DBObject>();
        Element[] elementArray = contextMenu.getContext().getSelection();
        if (elementArray != null && elementArray.length > 1) {
            for (Element element : elementArray) {
                DBObject dBObject = new DBObject(element);
                String string = dBObject.getObjectType();
                if (!(string.equalsIgnoreCase("CUBE") || string.equalsIgnoreCase("CUBE DIMENSION") || string.equalsIgnoreCase("CALCMEASURE"))) {
                    return;
                }
                this.dbObjects.add(dBObject);
            }
            this.addOptions(contextMenu);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void addOptions(ContextMenu contextMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_SAVE_TEMPLATE"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("TO_BOTH;XML");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
        JMenu jMenu = new JMenu(this.resources.getString("MULTIPLE_OBJECT_MENU_QUICK_DDL"));
        JMenuItem jMenuItem2 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_XML_TO_FILE"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("TO_FILE;XML");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_XML_TO_EDITOR"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("worksheet;XML");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_XML_TO_CLIPBOARD"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("clipboard;XML");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_PLSQL_TO_FILE"));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("TO_FILE;PLSQL");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_PLSQL_TO_WORKSHEET"));
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("worksheet;PLSQL");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(this.resources.getString("MULTIPLE_OBJECT_MENU_PLSQL_TO_CLIPBOARD"));
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this._action.setSelection(MultipleObjectContextMenu.this.dbObjects);
                MultipleObjectContextMenu.this._action.setArgs("clipboard;PLSQL");
                MultipleObjectContextMenu.this._action.launch();
            }
        });
        jMenu.add(jMenuItem7);
        contextMenu.add((Component)jMenu);
    }
}

