/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Dimension;
import java.awt.Frame;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropOLAPChildObjectAdapter;
import oracle.olap.actions.DropOLAPChildObjectDialog;
import oracle.olap.actions.LanguageDescriptionsTreeTablePanel;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.MetadataXML;

public class LanguageDescriptionsAction
extends AbstractMenuAction {
    private DropOLAPChildObjectDialog dialog;

    public void launch() {
        try {
            LanguageDescriptionsTreeTablePanel languageDescriptionsTreeTablePanel = new LanguageDescriptionsTreeTablePanel(this.getDBObject());
            this.dialog = new DropOLAPChildObjectDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("LANGUAGE_DESCRIPTIONS_DIALOG_TITLE"), languageDescriptionsTreeTablePanel, new LanguageDescriptionsAdapter(languageDescriptionsTreeTablePanel), "");
            this.dialog.setMinimumSize(new Dimension(1024, 768));
            this.dialog.setModal(true);
            this.dialog.setVisible(true);
            if (this.dialog.getUserSelection() == 0) {
                Schema schema = OLAPMetadataCache.getSchema(this.getDBObject().getConnectionName(), this.getDBObject().getSchemaName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class LanguageDescriptionsAdapter
    extends DropOLAPChildObjectAdapter {
        private LanguageDescriptionsTreeTablePanel descriptions;
        private String sqlXml;

        public LanguageDescriptionsAdapter(LanguageDescriptionsTreeTablePanel languageDescriptionsTreeTablePanel) {
            this.descriptions = languageDescriptionsTreeTablePanel;
        }

        @Override
        public String getSQL() {
            this.sqlXml = this.descriptions.generateSQL();
            return this.sqlXml;
        }

        @Override
        public boolean commitChanges() {
            MetadataXML metadataXML = this.descriptions.getMetadataXML();
            try {
                if (metadataXML != null) {
                    metadataXML.executeSQL(true);
                } else {
                    this.sqlXml = this.descriptions.generateSQL();
                    metadataXML = this.descriptions.getMetadataXML();
                    metadataXML.executeSQL(true);
                }
                Schema schema = OLAPMetadataCache.getSchema(LanguageDescriptionsAction.this.getDBObject().getConnectionName(), LanguageDescriptionsAction.this.getDBObject().getSchemaName());
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }
}

