/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.dml.DMLObject;
import oracle.olap.eif.ExportToEIFDialog;

public class ExportToEIFAction
extends AbstractMenuAction {
    public void launch() {
        DBObject dBObject = this.getDBObject();
        this.launchDialog(dBObject);
    }

    private void launchDialog(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        String string3 = null;
        String string4 = null;
        ExportToEIFDialog exportToEIFDialog = new ExportToEIFDialog((Frame)Ide.getMainWindow(), connection, string, string2);
        exportToEIFDialog.setMinimumSize(new Dimension(400, 150));
        exportToEIFDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        exportToEIFDialog.setVisible(true);
        if (exportToEIFDialog.isOKSelected()) {
            string3 = exportToEIFDialog.getEIFFileName();
            string4 = exportToEIFDialog.getDirectoryName();
        }
        if (string4 != null && string3 != null) {
            this.exportToEIFFile(connection, string, string2, string4, string3);
        }
    }

    private void exportToEIFFile(Connection connection, String string, String string2, String string3, String string4) {
        String string5 = OLAPArb.get("EIF_EXPORT_PROGRESSBAR_TITLE");
        string5 = MessageFormat.format(string5, "");
        final String string6 = string;
        final String string7 = string2;
        final Connection connection2 = connection;
        final String string8 = string3;
        final String string9 = string4;
        RaptorTask raptorTask = new RaptorTask(string5, true, IRaptorTaskRunMode.MODAL){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                boolean bl2 = false;
                String string = string6 + "." + string7;
                try {
                    this.setMessage(OLAPArb.get("EIF_EXPORT_PROGRESSBAR_WAIT_MSG"));
                    DatabaseUtils.ExecuteSPL(connection2, "cda '" + string8 + "'");
                    String string2 = DatabaseUtils.ExecuteSPL(connection2, "show aw(ATTACHED '" + string + "')");
                    bl2 = string2.equalsIgnoreCase("yes");
                    if (!bl2) {
                        DMLObject.runDML(connection2, "ATTACH_AW_RO_FIRST", string);
                    }
                    DatabaseUtils.ExecuteSPL(connection2, "limit name to all");
                    DatabaseUtils.ExecuteSPL(connection2, "allstat");
                    DMLObject.runDML(connection2, "EXPORT_AW_TO_EIF_FILE", string9);
                }
                catch (Exception exception) {
                    try {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) throw throwable;
                            DMLObject.runDML(connection2, "DETACH_AW", string);
                            throw throwable;
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (bl2) return bl;
                    DMLObject.runDML(connection2, "DETACH_AW", string);
                    return bl;
                }
                catch (Exception exception) {
                    return bl;
                }
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        ExportToEIFAction.this.warn(throwable);
                        ExportToEIFAction.this.showErrorDialog(throwable);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private void showErrorDialog(Throwable throwable) {
        String string = OLAPArb.get("EIF_EXPORT_ERROR_TITLE");
        ExceptionHandler.handleException((Throwable)throwable);
    }
}

