/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ConfirmDropMeasurePanel;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.calcs.ReferencesTableModel;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public class ConfirmDropCalculatedMeasurePanel
extends ConfirmDropMeasurePanel {
    private GenericTable referencesTable;
    private ReferencesTableModel referencesTableModel;
    private List<Measure> references;

    public ConfirmDropCalculatedMeasurePanel(String string, String string2, AnalyticWorkspace analyticWorkspace, String string3, List<Measure> list, Connection connection) {
        super(list, string);
        Measure measure;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", string3);
        Schema schema = SyntaxBuilderLauncher.populateSchema(null, properties, null, databaseImpl);
        OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(schema, properties);
        Cube cube = analyticWorkspace.getCube(string2);
        if (cube != null && (measure = cube.findMeasure(string)) != null) {
            this.references = CalcReferences.getReferences(measure, oLAPISyntaxParser, analyticWorkspace);
        }
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.referencesTableModel = new ReferencesTableModel();
        this.referencesTable = new GenericTable((TableModel)this.referencesTableModel);
        this.setupReferencesTable();
        this.populateTable();
    }

    private void setupReferencesTable() {
        this.referencesTable.setAutoResizeMode(0);
        this.referencesTable.setColumnSelectorAvailable(false);
        TableColumn tableColumn = this.referencesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.referencesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.referencesTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.referencesTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.referencesTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.referencesTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(385);
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)new JLabel(OLAPArb.format("DROP_MEASURE_NOTIFICATION", this.getMeasureName())), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        ++n;
        if (!this.getDependencies().isEmpty()) {
            this.add((Component)new JLabel(OLAPArb.getString("DROP_MEASURE_DEPENDENCIES_NOTIFICATION")), new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++n;
        }
        JSplitPane jSplitPane = new JSplitPane(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.getDependenciesTable());
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.referencesTable);
        ComponentWithTitlebar componentWithTitlebar2 = new ComponentWithTitlebar();
        componentWithTitlebar2.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.REFERENCES_TAB")));
        componentWithTitlebar2.setComponent((JComponent)jScrollPane2);
        jSplitPane.add((Component)componentWithTitlebar2, "bottom");
        jSplitPane.add((Component)componentWithTitlebar, "top");
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(0.7);
        this.add((Component)jSplitPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void populateTable() {
        if (this.references != null && !this.references.isEmpty()) {
            for (Measure measure : this.references) {
                Object[] objectArray;
                if (measure.getType().equals("DERIVED")) {
                    objectArray = new Object[]{measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getShortDescription(), measure.getDescription(), measure.getExpression()};
                    this.referencesTableModel.addRow(objectArray);
                    continue;
                }
                if (!measure.getType().equals("BASE")) continue;
                objectArray = new Object[]{measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getShortDescription(), measure.getDescription(), ""};
                this.referencesTableModel.addRow(objectArray);
            }
        }
    }
}

