/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.util.Namespace;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.buildreports.BuildStatusDialog;

public class BuildTask
extends RaptorTask<Boolean> {
    private static Queries queries;
    private static final String XMLFILE = "buildtask.xml";
    private static final String DBMS_CUBE_BUILD = "DBMS_CUBE_BUILD";
    private static final String IS_REFRESH_AFTER_ERROR = "isrefaftererr";
    private static final String IS_ATOMIC_REFRESH = "isatomic";
    private static final String IS_AUTO_ORDER_ON = "isautoorder";
    private static final String IS_AUTO_ADD_DIM_ON = "isautoadddim";
    private static final String BUILD_COMMANDS = "buildcommands";
    private static final String REFRESH_METHODS = "refmethod";
    private static final String PARALLEL_PROC_NUM = "numprocs";
    private static final String BUILD_ID = "buildid";
    private Namespace buildParams = null;
    private Connection conn;
    private String buildItems = null;
    private String refreshMethods = null;
    private int m_buildid;
    private BuildStatusDialog builddlg = null;
    private boolean isValidate = false;

    public BuildTask(Connection connection, Namespace namespace, String string, String string2, int n, BuildStatusDialog buildStatusDialog, boolean bl, String string3, boolean bl2, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl3, boolean bl4) {
        super(string3, bl2, iRaptorTaskRunMode);
        this.setMessage(OLAPArb.format("BUILD_PROGRESSBAR_TITLE", string));
        this.setPausable(bl3);
        this.setCancellable(bl4);
        this.conn = connection;
        this.buildParams = namespace;
        this.buildItems = string;
        this.refreshMethods = string2;
        this.m_buildid = n;
        if (bl) {
            buildStatusDialog = null;
        }
        this.builddlg = buildStatusDialog;
        this.isValidate = bl;
    }

    protected Boolean doWork() throws TaskException {
        Boolean bl = Boolean.TRUE;
        try {
            boolean bl2 = (Boolean)this.buildParams.get("ISATOMIC");
            int n = bl2 ? 1 : 0;
            boolean bl3 = (Boolean)this.buildParams.get("REFRESH_AFTER_ERROR");
            int n2 = bl3 ? 1 : 0;
            boolean bl4 = (Boolean)this.buildParams.get("AUTOORDER");
            int n3 = bl4 ? 1 : 0;
            boolean bl5 = (Boolean)this.buildParams.get("ADDDIM");
            int n4 = bl5 ? 1 : 0;
            int n5 = (Integer)this.buildParams.get("PARALLEL_PROC_NUM");
            String string = this.getQuery(DBMS_CUBE_BUILD);
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setInt(IS_REFRESH_AFTER_ERROR, n2);
            oracleCallableStatement.setInt(IS_ATOMIC_REFRESH, n);
            oracleCallableStatement.setInt(IS_AUTO_ORDER_ON, n3);
            oracleCallableStatement.setInt(IS_AUTO_ADD_DIM_ON, n4);
            if (this.isValidate) {
                oracleCallableStatement.setString(BUILD_COMMANDS, "VALIDATE " + this.buildItems);
            } else {
                oracleCallableStatement.setString(BUILD_COMMANDS, this.buildItems);
            }
            oracleCallableStatement.setString(REFRESH_METHODS, this.refreshMethods);
            oracleCallableStatement.setInt(PARALLEL_PROC_NUM, n5);
            oracleCallableStatement.setInt(BUILD_ID, this.m_buildid);
            try {
                oracleCallableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
        }
        catch (Exception exception) {
            bl = Boolean.FALSE;
            throw new TaskException((Throwable)exception);
        }
        finally {
            if (this.builddlg != null) {
                this.builddlg.enableClose();
            }
        }
        return bl;
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        BuildTask.queries = queries;
    }
}

