/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.BuildAction;
import oracle.olap.actions.BuildActionReportDialog;
import oracle.olap.actions.BuildActionReportPanel;
import oracle.olap.build.log.BuildLog;
import oracle.olap.build.log.BuildLog112;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class AnalyzeAction
extends BuildAction {
    private final String SUMMARY_FOR_LAST_BUILD = "SUMMARY_FOR_LAST_BUILD";
    private final String XMLFILE = "buildactionqueries.xml";
    private OLAPBuildLogPreferenceSettings buildLogSettings;

    public AnalyzeAction() {
        this.useWiz = false;
        Preferences preferences = Preferences.getPreferences();
        this.buildLogSettings = OLAPBuildLogPreferenceSettings.getInstance((PropertyStorage)preferences);
    }

    @Override
    protected String getBuildScript(String string) {
        String string2 = String.format("%s USING (ANALYZE)", string);
        return string2;
    }

    @Override
    protected String getXMLFile() {
        return "buildactionqueries.xml";
    }

    @Override
    protected JComponent getConfirmPromptPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string2 = this.getDBObject().getObjectName();
        jPanel.add((Component)new JLabel(OLAPArb.format("BUILD_ANALYZE_PROMPT_MSG", string2)), "North");
        return jPanel;
    }

    @Override
    protected BuildAction.OLAPBuildObjectHelper getHelper() {
        return new BuildAction.OLAPBuildObjectHelper(){

            @Override
            protected void createBuildLogTables(DBObject dBObject) throws Exception {
                String string = AnalyzeAction.this.buildLogSettings.getLogLevel();
                int n = AnalyzeAction.this.buildLogSettings.getMaxErrorsLogged();
                Connection connection = dBObject.getConnection();
                BuildLog buildLog = AnalyzeAction.this.getBuildLog(connection);
                buildLog.createAllBuildLogTables(string, n);
                buildLog.getEnableAllLogsScript();
            }
        };
    }

    private BuildLog getBuildLog(Connection connection) throws Exception {
        BuildLog112 buildLog112 = null;
        buildLog112 = new BuildLog112(connection);
        return buildLog112;
    }

    @Override
    protected String getBuildProgressBarDialogTitle(String string) {
        String string2 = OLAPArb.format("BUILD_ANALYZE_PROGRESSBAR_TITLE", string);
        return string2;
    }

    @Override
    protected String getBuildProgressBarDialogWaitMsg(String string) {
        String string2 = OLAPArb.get("BUILD_ANALYZE_PROGRESSBAR_WAIT_MSG");
        return string2;
    }

    @Override
    protected void showErrorDialog(String string) {
        String string2 = OLAPArb.get("BUILD_ANALYZE_ERROR_DLG_TITLE");
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }

    @Override
    protected void showSuccessfulCompletionDialog(String string) {
        String string2 = this.getBuildProgressBarDialogTitle(string);
        String string3 = this.getQuery("SUMMARY_FOR_LAST_BUILD");
        DBObject dBObject = this.getDBObject();
        String string4 = OLAPArb.get("BUILD_ANALYZE_REPORT_TABLE_TITLE");
        BuildActionReportPanel buildActionReportPanel = new BuildActionReportPanel(dBObject.getObjectName(), string3, dBObject.getDatabase(), string4);
        BuildActionReportDialog buildActionReportDialog = new BuildActionReportDialog(Ide.getMainWindow(), buildActionReportPanel, string2);
        buildActionReportDialog.setModal(true);
        buildActionReportDialog.setVisible(true);
    }

    @Override
    protected String getConfirmMessage(String string) {
        String string2 = OLAPArb.format("BUILD_ANALYZE_PROMPT_MSG", string);
        return string2;
    }

    @Override
    protected String getConfirmTitle(String string) {
        String string2 = this.getBuildProgressBarDialogTitle(string);
        return string2;
    }
}

