/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.util.Map;
import javax.swing.DefaultListModel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.db.model.LanguageDescriptionsHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractUpdatedObjectGenerator {
    private final DefaultListModel descriptionTranslations;
    private final String[] initialLanguages;

    public AbstractUpdatedObjectGenerator(DefaultListModel defaultListModel, String[] stringArray) {
        this.descriptionTranslations = defaultListModel;
        this.initialLanguages = stringArray;
    }

    protected void setDescriptions(Node node, XPath xPath, Descriptions descriptions, LanguageDescriptionsHelper languageDescriptionsHelper) throws Exception {
        Object object;
        if (this.initialLanguages != null && this.initialLanguages.length != this.descriptionTranslations.size()) {
            for (String string : this.initialLanguages) {
                if (this.descriptionTranslations.contains(string) || (object = languageDescriptionsHelper.findLanguageDescription(string)) == null) continue;
                languageDescriptionsHelper.removeLanguageDescription((LanguageDescription)object);
            }
        }
        if (descriptions != null) {
            String string;
            Object object2 = xPath.compile("*/@description");
            String string2 = object2.evaluate(node);
            if (!(string2 = string2.trim()).equalsIgnoreCase(descriptions.getDescription())) {
                descriptions.setDescription(string2);
            }
            object2 = xPath.compile("*/@shortDescription");
            String string3 = object2.evaluate(node);
            if (!(string3 = string3.trim()).equalsIgnoreCase(descriptions.getShortDescription())) {
                descriptions.setShortDescription(string3);
            }
            object2 = xPath.compile("*/@longDescription");
            string = object2.evaluate(node);
            if (!(string = string.trim()).equalsIgnoreCase(descriptions.getLongDescription())) {
                descriptions.setLongDescription(string);
            }
            object2 = xPath.compile("./*[@language]");
            object = object2.evaluate(node, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.addLanguageDescriptions(xPath, nodeList.item(i), languageDescriptionsHelper);
            }
        }
    }

    public void generateUpdatedObject(NodeList nodeList, Map<String, AbstractSchemaObjectWithDesc> map, Map<String, AbstractSchemaObjectWithDesc> map2) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            this.traverse(node, xPath, map, map2);
        }
    }

    private void addLanguageDescriptions(XPath xPath, Node node, LanguageDescriptionsHelper languageDescriptionsHelper) throws Exception {
        if (languageDescriptionsHelper != null) {
            XPathExpression xPathExpression = xPath.compile("@language");
            String string = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@description");
            String string2 = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@shortDescription");
            String string3 = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@longDescription");
            String string4 = xPathExpression.evaluate(node);
            LanguageDescription languageDescription = languageDescriptionsHelper.findLanguageDescription(string);
            if (languageDescription != null) {
                languageDescription.setDescription(string2);
                languageDescription.setShortDescription(string3);
                languageDescription.setLongDescription(string4);
            } else {
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                languageDescription.setDescription(string2);
                languageDescription.setShortDescription(string3);
                languageDescription.setLongDescription(string4);
                languageDescriptionsHelper.addLanguageDescription(languageDescription);
            }
        }
    }

    protected abstract void traverse(Node var1, XPath var2, Map<String, AbstractSchemaObjectWithDesc> var3, Map<String, AbstractSchemaObjectWithDesc> var4) throws Exception;
}

