/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import javax.swing.KeyStroke;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.util.XmlSelectionAction;
import org.w3c.dom.Element;

public class XmlTransferableSelectionAction
extends XmlSelectionAction {
    private final boolean _checkTransferable;
    private final boolean _checkDeletable;

    public XmlTransferableSelectionAction(String mnemonicAndDisplayName, KeyStroke accelerator, String actionCommand, boolean checkTransferable, boolean checkDeletable) {
        super(mnemonicAndDisplayName, accelerator, actionCommand, true);
        this._checkTransferable = checkTransferable;
        this._checkDeletable = checkDeletable;
    }

    @Override
    protected boolean isEnabledImpl() {
        if (!super.isEnabledImpl()) {
            return false;
        }
        AbstractModel model = this.getModel();
        XmlMetadataResolver resolver = model.getXmlMetadataResolver();
        if (this._checkTransferable && !resolver.isSelectionTransferable()) {
            return false;
        }
        if (this._checkDeletable) {
            if (!resolver.isSelectionDeletable()) {
                return false;
            }
            Element root = model.getDocument().getDocumentElement();
            if (model.requiresValidModel() && model.getSelection().contains(root)) {
                return false;
            }
        }
        return true;
    }
}

