/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.KeyStroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.share.BaseAction;
import org.w3c.dom.Node;

public class XmlNavigationActions
implements ActionListener {
    private final XmlView _view;
    private final TreeTraversal _traversal;
    private final Action _nextAction;
    private final Action _previousAction;
    private final Action _nextInsertionPositionAction;
    private final Action _previousInsertionPositionAction;

    public XmlNavigationActions(XmlView view, TreeTraversal traversal) {
        if (view == null) {
            throw new IllegalArgumentException("view must be non-null");
        }
        this._view = view;
        this._traversal = traversal;
        this._nextAction = new BaseAction(view.getTranslatedString("NEXT_DESCRIPTION"), 78, KeyStroke.getKeyStroke(9, 0), "nextNode", this);
        this._previousAction = new BaseAction(view.getTranslatedString("PREVIOUS_DESCRIPTION"), 80, KeyStroke.getKeyStroke(9, 1), "prevNode", this);
        this._nextInsertionPositionAction = new BaseAction(view.getTranslatedString("CURSOR_FORWARD_DESCRIPTION"), 0, KeyStroke.getKeyStroke(39, 2), "nextInsertionPos", this);
        this._previousInsertionPositionAction = new BaseAction(view.getTranslatedString("CURSOR_BACKWARD_DESCRIPTION"), 0, KeyStroke.getKeyStroke(37, 2), "prevInsertionPos", this);
    }

    public Action getNextInsertionPositionAction() {
        return this._nextInsertionPositionAction;
    }

    public Action getPreviousInsertionPositionAction() {
        return this._previousInsertionPositionAction;
    }

    public Action getNextAction() {
        return this._nextAction;
    }

    public Action getPreviousAction() {
        return this._previousAction;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        final Selection selection = this._view.getSelection();
        final boolean isPreviousCmd = "prevNode".equals(cmd);
        final boolean isNextCmd = "nextNode".equals(cmd);
        final boolean isPosPreviousCmd = "prevInsertionPos".equals(cmd);
        final boolean isPosNextCmd = "nextInsertionPos".equals(cmd);
        new NonDomMutationTransactionTask(){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (isPreviousCmd || isNextCmd) {
                    if (selection.isEmpty()) {
                        XmlNavigationActions.this._selectCursorNodeInsideTask(selection);
                    } else {
                        XmlNavigationActions.this._doPrevOrNextNodeInsideTask(isPreviousCmd, selection);
                    }
                } else if (isPosPreviousCmd || isPosNextCmd) {
                    XmlNavigationActions.this._handleInsertionPosPrevNextInsideTask(isPosPreviousCmd, selection);
                }
            }
        }.run(this._view);
    }

    private void _handleInsertionPosPrevNextInsideTask(boolean isPrevious, Selection selection) {
        DomPosition newCursor;
        DomPosition oldCursor = selection.getCursorLocation();
        if (oldCursor == null) {
            if (!selection.isEmpty()) {
                oldCursor = isPrevious ? DomPositionFactory.createInsideOrBeforePosition((Node)selection.getEarliestSelectedNode()) : DomPositionFactory.createInsideOrAfterPosition((Node)selection.getLatestSelectedNode());
            } else {
                return;
            }
        }
        do {
            oldCursor = newCursor = this._findNextInsertionPos(isPrevious, selection, oldCursor);
        } while (newCursor != null && !newCursor.equals((Object)this._view.convertInsertionPosition(newCursor)));
        if (newCursor != null) {
            selection.setCursorLocation(newCursor);
        }
    }

    private DomPosition _findNextInsertionPos(boolean isPrevious, Selection selection, DomPosition oldCursor) {
        XmlMetadataResolver resolver = this._view.getXmlMetadataResolver();
        Node oldCursorNode = oldCursor.getTargetNode();
        DomPosition newCursor = null;
        if (isPrevious) {
            if (oldCursor.isInside()) {
                newCursor = oldCursor.getBeforePosition();
            } else if (oldCursor.isAfter()) {
                Node lastChild = this._traversal.getLastChild(oldCursorNode);
                newCursor = lastChild != null ? DomPositionFactory.createDomPosition((Node)lastChild, (int)2) : (resolver.allowsChildren(oldCursorNode) && resolver.canAddChild(DomPositionFactory.inside((Node)oldCursorNode)) ? oldCursor.getInsidePosition() : oldCursor.getBeforePosition());
            } else {
                Node prevSiblingNode = this._traversal.getPreviousSibling(oldCursorNode);
                if (prevSiblingNode != null) {
                    newCursor = DomPositionFactory.createDomPosition((Node)prevSiblingNode, (int)2);
                } else {
                    Node parentNode = this._traversal.getParentNode(oldCursorNode);
                    if (parentNode != null) {
                        newCursor = DomPositionFactory.createDomPosition((Node)parentNode, (int)1);
                    }
                }
            }
        } else if (oldCursor.isInside()) {
            newCursor = oldCursor.getAfterPosition();
        } else if (oldCursor.isBefore()) {
            Node firstChild = this._traversal.getFirstChild(oldCursorNode);
            newCursor = firstChild != null ? DomPositionFactory.createDomPosition((Node)firstChild, (int)1) : (resolver.allowsChildren(oldCursorNode) && resolver.canAddChild(DomPositionFactory.inside((Node)oldCursorNode)) ? oldCursor.getInsidePosition() : oldCursor.getAfterPosition());
        } else {
            Node nextSiblingNode = this._traversal.getNextSibling(oldCursorNode);
            if (nextSiblingNode != null) {
                newCursor = DomPositionFactory.createDomPosition((Node)nextSiblingNode, (int)1);
            } else {
                Node parentNode = this._traversal.getParentNode(oldCursorNode);
                if (parentNode != null) {
                    newCursor = DomPositionFactory.createDomPosition((Node)parentNode, (int)2);
                }
            }
        }
        return newCursor;
    }

    private void _selectCursorNodeInsideTask(Selection selection) {
        DomPosition cursor = selection.getCursorLocation();
        if (cursor != null) {
            selection.set(cursor.getTargetNode());
        }
    }

    private void _doPrevOrNextNodeInsideTask(boolean isPreviousCmd, Selection selection) {
        Node selectedNode;
        if (isPreviousCmd) {
            selectedNode = selection.getEarliestSelectedNode();
            if ((selectedNode = this._traversal.getPreviousNode(selectedNode)) == null || selectedNode.getNodeType() == 9) {
                selectedNode = DomUtils.getLastDescendant((TreeTraversal)this._traversal, (Node)this._view.getDocument());
            }
        } else {
            selectedNode = selection.getLatestSelectedNode();
            if ((selectedNode = this._traversal.getNextNode(selectedNode)) == null) {
                selectedNode = this._view.getDocument();
                selectedNode = this._traversal.getNextNode(selectedNode);
            }
        }
        if (selectedNode == null) {
            return;
        }
        XmlMetadataResolver viewResolver = this._view.getXmlMetadataResolver();
        int relativeCursorPos = viewResolver.allowsChildren(selectedNode) && viewResolver.canAddChild(DomPositionFactory.inside((Node)selectedNode)) ? 0 : (isPreviousCmd ? 1 : 2);
        DomPosition cursorPosition = DomPositionFactory.createDomPosition((Node)selectedNode, (int)relativeCursorPos);
        selection.setCursorLocation(cursorPosition);
        selection.set(selectedNode);
    }
}

