/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.util.XmlModelUtils;
import org.w3c.dom.Node;

public class XmlCreationAction
extends AbstractAction {
    private static final String _CREATE_COMMAND = "create";
    private boolean _iconInitialized = false;
    private List _xmlKeys;
    private DomPosition _position;
    private AbstractModel _model;
    private static final Logger _LOGGER = Logger.getLogger(XmlCreationAction.class.getName());

    public XmlCreationAction(AbstractModel model, DomPosition position, XmlKey key) {
        this._init(model, position, Collections.singletonList(key));
    }

    public XmlCreationAction(AbstractModel model, DomPosition position, List xmlKeyList) {
        this._init(model, position, Collections.unmodifiableList(xmlKeyList));
    }

    public static List createActions(AbstractModel model, List creatableKeyLists, DomPosition position) {
        ArrayList<XmlCreationAction> actions = new ArrayList<XmlCreationAction>(creatableKeyLists.size());
        for (List childKeyList : creatableKeyLists) {
            actions.add(new XmlCreationAction(model, position, childKeyList));
        }
        return actions;
    }

    public static Collection createLazyActionCollectionFromKeyCollection(final AbstractModel model, final DomPosition position, final Collection keyCollection) {
        return new AbstractCollection(){

            @Override
            public int size() {
                return keyCollection.size();
            }

            @Override
            public Iterator iterator() {
                return new Itor();
            }

            class Itor
            implements Iterator {
                private final Iterator _realItor;

                Itor() {
                    this._realItor = keyCollection.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._realItor.hasNext();
                }

                public Object next() {
                    XmlKey key = (XmlKey)this._realItor.next();
                    return new XmlCreationAction(model, position, key);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            XmlModelUtils.setModalDialogRunning(true);
            if (this.getLastXmlKey() != null) {
                final List xmlKeys = this.getXmlKeys();
                final int keyCount = xmlKeys.size();
                String transDescFormat = this._model.getTranslatedString("INSERT_DESCRIPTION_FORMAT");
                String transDescription = FastMessageFormat.formatMessage(transDescFormat, this.getValue("Name").toString());
                new FixedNameTransactionTask(transDescription){

                    @Override
                    protected void performTask(AbstractModel model) throws XmlCommitException {
                        DomPosition position = XmlCreationAction.this._position;
                        int i = 0;
                        while (true) {
                            XmlKey currKey = (XmlKey)xmlKeys.get(i);
                            Node createdNode = XmlCreationAction.this._model.insertXmlKey(currKey, position);
                            if (++i >= keyCount) break;
                            if (createdNode == null) continue;
                            position = DomPositionFactory.createInsideOrAfterPosition((Node)createdNode);
                        }
                    }
                }.run(this._model);
            } else {
                _LOGGER.log(Level.WARNING, "Can't create element because no XmlKey for {0}", this);
            }
        }
        finally {
            XmlModelUtils.setModalDialogRunning(false);
        }
    }

    public List getXmlKeys() {
        return this._xmlKeys;
    }

    public XmlKey getLastXmlKey() {
        List xmlKeys = this.getXmlKeys();
        int size = xmlKeys.size();
        if (size == 0) {
            return null;
        }
        return (XmlKey)xmlKeys.get(size - 1);
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if ("SmallIcon".equals(key) && !this._iconInitialized) {
            value = this._createIcon();
            this._iconInitialized = true;
        }
        return value;
    }

    public String toString() {
        return (String)this.getValue("Name");
    }

    private Icon _createIcon() {
        XmlKey lastXmlKey = this.getLastXmlKey();
        if (lastXmlKey != null) {
            Icon smallIcon = this._model.getXmlMetadataResolver().getSmallIcon(lastXmlKey);
            if (smallIcon != null) {
                this.putValue("SmallIcon", smallIcon);
            }
            return smallIcon;
        }
        return null;
    }

    private void _init(AbstractModel model, DomPosition position, List xmlKeyList) {
        this.putValue("ActionCommandKey", _CREATE_COMMAND);
        this._model = model;
        this._position = position;
        this._xmlKeys = xmlKeyList;
        XmlKey lastKey = this.getLastXmlKey();
        this.setEnabled(lastKey != null);
        String name = model.getXmlMetadataResolver().getShortDisplayName(lastKey);
        this.putValue("Name", name);
        char mnemonic = Character.toUpperCase(name.charAt(0));
        this.putValue("MnemonicKey", new Integer(mnemonic));
    }
}

