/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypePropertyEditorProvider;

public class SimpleTypePropertyEditorManager {
    private static SimpleTypePropertyEditorManager _simpleTypePropertyEditorManager = null;
    private final ConcurrentHashMap<QualifiedName, Class> _propertyEditorClasses = new ConcurrentHashMap();
    private final ArrayList<SimpleTypePropertyEditorProvider> _propertyEditorProviders = new ArrayList();

    public static SimpleTypePropertyEditorManager getInstance() {
        if (_simpleTypePropertyEditorManager == null) {
            _simpleTypePropertyEditorManager = new SimpleTypePropertyEditorManager();
        }
        return _simpleTypePropertyEditorManager;
    }

    public PropertyEditor getPropertyEditor(SimpleType type) throws GrammarException {
        Class c;
        SimpleTypePropertyEditorProvider provider;
        if (type == null) {
            throw new GrammarException("PropertyEditorManager:getPropertyEditor() type parameter cannot be null");
        }
        PropertyEditor pe = null;
        Iterator<SimpleTypePropertyEditorProvider> iterator = this._propertyEditorProviders.iterator();
        while (iterator.hasNext() && (pe = (provider = iterator.next()).getPropertyEditor(type)) == null) {
        }
        if (pe == null && (c = (Class)JavaTypeManager.getInstance().findBestMatch(type, this._propertyEditorClasses, false)) != null) {
            try {
                pe = (PropertyEditor)c.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return pe;
    }

    public final void registerPropertyEditor(String namespace, String simpleTypeName, Class propertyEditor) {
        QualifiedName qName = QualifiedName.getQualifiedName((String)namespace, (String)simpleTypeName);
        this.registerPropertyEditor(qName, propertyEditor);
    }

    public void registerPropertyEditor(QualifiedName simpleTypeName, Class propertyEditor) {
        if (!PropertyEditor.class.isAssignableFrom(propertyEditor)) {
            throw new IllegalArgumentException("propertyEditor must implement java.beans.PropertyEditor");
        }
        if (simpleTypeName != null) {
            this._propertyEditorClasses.put(simpleTypeName, propertyEditor);
        }
    }

    public final void registerPropertyEditor(SimpleTypePropertyEditorProvider provider) {
        if (!this._propertyEditorProviders.contains(provider)) {
            this._propertyEditorProviders.add(provider);
        }
    }

    private SimpleTypePropertyEditorManager() {
    }
}

