/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.share.clipboard.NullTransferable;
import oracle.javatools.logging.LogUtils;

public abstract class ClipboardManager {
    public static final Transferable EMPTY_CONTENTS = new NullTransferable("empty");
    public static final Transferable UNKNOWN_CONTENTS = new NullTransferable("unknown");
    private boolean _isAppActive = true;
    private final Set _listenerRefs = new LinkedHashSet();
    private final ReferenceQueue _queue = new ReferenceQueue();
    private static final Logger _sLOGGER = Logger.getLogger(ClipboardManager.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFlavorListener(ChangeListener listener) {
        boolean wasEmpty = !this.areFlavorListenersAttached();
        Set set = this._listenerRefs;
        synchronized (set) {
            Iterator toAddItor = this._findListener(listener);
            if (toAddItor != null) {
                this.getLogger().log(Level.SEVERE, "Tried to add listener that was already attached: {0}", listener);
            } else {
                WeakReference<ChangeListener> ref = new WeakReference<ChangeListener>(listener, this._queue);
                if (this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "Adding listener {0} via ref {1}", new Object[]{listener, ref});
                }
                this._listenerRefs.add(ref);
            }
        }
        if (wasEmpty) {
            this.areFlavorListenersAttachedChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFlavorListener(ChangeListener listener) {
        Set set = this._listenerRefs;
        synchronized (set) {
            Iterator toRemoveItor = null;
            Reference ref = null;
            Iterator itor = this._listenerRefs.iterator();
            while (itor.hasNext()) {
                ref = (Reference)itor.next();
                if (listener != ref.get()) continue;
                toRemoveItor = itor;
                break;
            }
            if (toRemoveItor == null) {
                this.getLogger().log(Level.SEVERE, "Tried to remove listener that was not attached: {0}", listener);
            } else {
                if (this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "Removing listener {0}; refs set before={1}", new Object[]{listener, this._listenerRefs});
                }
                ref.clear();
                toRemoveItor.remove();
                if (this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "Removed listener {0}; refs set after={1}", new Object[]{listener, this._listenerRefs});
                }
            }
            this._removeDeadListenerReferences();
        }
        if (!this.areFlavorListenersAttached()) {
            this.areFlavorListenersAttachedChanged();
        }
    }

    public abstract Transferable getContents();

    public abstract void setContents(Transferable var1) throws IllegalStateException;

    public DataFlavor[] getAvailableDataFlavors() {
        return ClipboardManager.fixNullFlavorArray(this.getContents().getTransferDataFlavors());
    }

    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        return this.getContents().isDataFlavorSupported(flavor);
    }

    public Object getData(DataFlavor flavor) throws IOException, UnsupportedFlavorException {
        return this.getContents().getTransferData(flavor);
    }

    public void setApplicationActive(boolean isActive) {
        boolean changed = isActive != this._isAppActive;
        this._isAppActive = isActive;
        if (changed) {
            this.applicationActiveChanged();
        }
    }

    public boolean isApplicationActive() {
        return this._isAppActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean areFlavorListenersAttached() {
        Set set = this._listenerRefs;
        synchronized (set) {
            return !this._listenerRefs.isEmpty();
        }
    }

    protected void areFlavorListenersAttachedChanged() {
    }

    protected void applicationActiveChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFlavorListeners() {
        if (this.areFlavorListenersAttached()) {
            Reference[] refs;
            _sLOGGER.finer("notifying flavor listeners!");
            Set set = this._listenerRefs;
            synchronized (set) {
                this._removeDeadListenerReferences();
                if (!this.areFlavorListenersAttached()) {
                    this.areFlavorListenersAttachedChanged();
                    refs = null;
                } else {
                    refs = this._listenerRefs.toArray(new Reference[this._listenerRefs.size()]);
                }
            }
            if (refs != null && refs.length > 0) {
                ChangeEvent event = new ChangeEvent(this);
                for (int i = 0; i < refs.length; ++i) {
                    ChangeListener listener = (ChangeListener)refs[i].get();
                    if (listener == null) continue;
                    try {
                        listener.stateChanged(event);
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LogUtils.log((Logger)this.getLogger(), (Level)Level.SEVERE, (String)"Unexpected exception notifying flavor listener {0}", (Object)listener, (Throwable)t);
                    }
                }
            }
        }
    }

    protected final Logger getLogger() {
        return _sLOGGER;
    }

    protected static final boolean areDifferent(DataFlavor[] a, DataFlavor[] b) {
        return !Arrays.equals(a, b);
    }

    protected static DataFlavor[] fixNullFlavorArray(DataFlavor[] array) {
        if (array == null) {
            return EMPTY_CONTENTS.getTransferDataFlavors();
        }
        return array;
    }

    private void _removeDeadListenerReferences() {
        Reference ref;
        int removedCount = 0;
        while ((ref = this._queue.poll()) != null) {
            boolean ok = this._listenerRefs.remove(ref);
            if (!ok) {
                this.getLogger().log(Level.SEVERE, "Dead reference not found in the set! {0}", ref);
            }
            ++removedCount;
        }
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "Cleaned up {0} dead listener references; attached={1}", new Object[]{new Integer(removedCount), this._listenerRefs});
        }
    }

    private Iterator _findListener(ChangeListener listener) {
        Iterator itor = this._listenerRefs.iterator();
        while (itor.hasNext()) {
            Reference ref = (Reference)itor.next();
            if (listener != ref.get()) continue;
            return itor;
        }
        return null;
    }
}

