/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DualUndoableEdit
implements UndoableEdit {
    private UndoableEdit _undo1;
    private UndoableEdit _undo2;

    public DualUndoableEdit(UndoableEdit undo1, UndoableEdit undo2) {
        if (undo1 == null || undo2 == null) {
            throw new IllegalArgumentException("null undoable edit");
        }
        this._undo1 = undo1;
        this._undo2 = undo2;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this._undo1.undo();
        this._undo2.undo();
    }

    @Override
    public boolean canUndo() {
        return this._undo1.canUndo() && this._undo2.canUndo();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotUndoException();
        }
        this._undo1.redo();
        this._undo2.redo();
    }

    @Override
    public boolean canRedo() {
        return this._undo1.canRedo() && this._undo2.canRedo();
    }

    @Override
    public void die() {
        this._undo1.die();
        this._undo2.die();
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return this._undo1.isSignificant() || this._undo2.isSignificant();
    }

    @Override
    public String getPresentationName() {
        return this._undo1.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        return this._undo1.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this._undo1.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " undo1: " + this._undo1 + " undo2: " + this._undo2;
    }
}

