/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageIssueList;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.util.CompositeIterator;
import org.w3c.dom.Node;

public final class XmlModelMessageLog
implements IssueList {
    private final Map<MessageCategory, XmlModelMessageIssueList> _messages;
    private volatile List<XmlModelMessage> _flattenedMessages;
    private volatile int _errorCount = -1;
    private volatile int _warningCount = -1;
    private volatile int _incompleteCount = -1;
    private volatile int _advisoryCount = -1;
    private volatile int _size = -1;

    public static XmlModelMessageLog createEmptyMessageLog() {
        Map<MessageCategory, XmlModelMessageIssueList> emptyMap = Collections.emptyMap();
        return new XmlModelMessageLog(emptyMap);
    }

    public static XmlModelMessageLog createUpdatedMessageLog(XmlModelMessageLog original, MessageCategory category, XmlModelMessageIssueList messages) {
        if (original == null) {
            throw new IllegalArgumentException("Null original XmlModelMessageLog passed to createUpdatedMessageLog");
        }
        LinkedHashMap<MessageCategory, XmlModelMessageIssueList> newMap = new LinkedHashMap<MessageCategory, XmlModelMessageIssueList>(original._messages);
        if (messages == null) {
            newMap.remove(category);
        } else {
            newMap.put(category, messages);
        }
        return new XmlModelMessageLog(newMap);
    }

    public List<XmlModelMessage> getMessages(MessageCategory category) {
        XmlModelMessageIssueList issueListForCategory = this._messages.get(category);
        if (issueListForCategory != null) {
            return issueListForCategory.getMessages();
        }
        return Collections.emptyList();
    }

    public int size() {
        this._computeCounts();
        return this._size;
    }

    public Severity getSeverity() {
        if (this.getErrorCount() > 0) {
            return Severity.ERROR;
        }
        if (this.getWarningCount() > 0) {
            return Severity.WARNING;
        }
        if (this.getIncompleteCount() > 0) {
            return Severity.INCOMPLETE;
        }
        return Severity.OK;
    }

    public boolean isStale() {
        return false;
    }

    public int getErrorCount() {
        this._computeCounts();
        return this._errorCount;
    }

    public int getWarningCount() {
        this._computeCounts();
        return this._warningCount;
    }

    public int getIncompleteCount() {
        this._computeCounts();
        return this._incompleteCount;
    }

    public int getAdvisoryCount() {
        this._computeCounts();
        return this._advisoryCount;
    }

    public List<Issue> getOptionalAnalyses() {
        return Collections.emptyList();
    }

    public Iterator<Issue> iterator() {
        ArrayList<Iterator> iteratorList = new ArrayList<Iterator>(this._messages.size());
        for (XmlModelMessageIssueList list : this._messages.values()) {
            Iterator iter = list.iterator();
            if (!iter.hasNext()) continue;
            iteratorList.add(iter);
        }
        return new CompositeIterator(iteratorList);
    }

    public Issue getIssueAt(int index) {
        if (this._flattenedMessages == null) {
            ArrayList<XmlModelMessage> flattenedMessages = new ArrayList<XmlModelMessage>(this.size());
            for (XmlModelMessageIssueList list : this._messages.values()) {
                flattenedMessages.addAll(list.getMessages());
            }
            this._flattenedMessages = flattenedMessages;
        }
        return this._flattenedMessages.get(index);
    }

    public List<XmlModelMessage> getNodeMessageList(Node node) {
        List<XmlModelMessage> nodeMessages = Collections.emptyList();
        if (node == null) {
            return nodeMessages;
        }
        for (XmlModelMessageIssueList l : this._messages.values()) {
            for (XmlModelMessage message : l.getMessages()) {
                if (message.getRelatedNode() != node) continue;
                if (nodeMessages.isEmpty()) {
                    nodeMessages = new ArrayList<XmlModelMessage>();
                }
                nodeMessages.add(message);
            }
        }
        return nodeMessages;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (XmlModelMessageIssueList list : this._messages.values()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Issue issue = (Issue)iterator.next();
                buf.append(issue);
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    private void _computeCounts() {
        if (this._size == -1) {
            int size = 0;
            int errorCount = 0;
            int warningCount = 0;
            int incompleteCount = 0;
            int advisoryCount = 0;
            for (XmlModelMessageIssueList list : this._messages.values()) {
                size += list.size();
                errorCount += list.getErrorCount();
                warningCount += list.getWarningCount();
                incompleteCount += list.getIncompleteCount();
                advisoryCount += list.getAdvisoryCount();
            }
            this._advisoryCount = advisoryCount;
            this._incompleteCount = incompleteCount;
            this._warningCount = warningCount;
            this._errorCount = errorCount;
            this._size = size;
        }
    }

    private XmlModelMessageLog(Map<MessageCategory, XmlModelMessageIssueList> messages) {
        this._messages = Collections.unmodifiableMap(messages);
    }
}

