/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlContextReference;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.CommandResult;
import oracle.bali.xml.model.dependency.DeclarationBase;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ValueInfo;
import oracle.bali.xml.model.task.NonValidatingTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class XmlDeclaration
extends DeclarationBase {
    private XmlContextReference _xmlContextRef;
    private WeakReference _weakNode;
    private URL _fileUrl;
    private String _nodePath;
    private String _attributeNS;
    private String _attribute;
    private int _start;
    private int _end;

    public XmlDeclaration(XmlContext xmlContext, Node node, int start, int end) {
        this._xmlContextRef = xmlContext.getXmlContextReference();
        this._fileUrl = xmlContext.getURL();
        this._weakNode = new WeakReference<Node>(node);
        if (DomUtils.isAttribute((Node)node)) {
            Attr attr = (Attr)node;
            this._attribute = DomUtils.getLocalName((Node)attr);
            String attrNS = attr.getNamespaceURI();
            if (attrNS != null) {
                this._attributeNS = attrNS;
            }
            node = attr.getOwnerElement();
        }
        this._nodePath = DependencyUtils.createNodePathString(node);
        this._start = start;
        this._end = end;
    }

    public DomRange getDomRange(DependencyContext context) {
        Node node = this.getNode(context);
        return DomRange.create((DomPosition)DependencyUtils.__getDomPosition(node, this._start), (DomPosition)DependencyUtils.__getDomPosition(node, this._end), (TreeTraversal)DocumentTreeTraversal.INSTANCE);
    }

    @Override
    protected String getDisplayTextImpl(DependencyContext context) {
        return context.getDisplayText(this.getXmlContext(context), this.getNode(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean supportsRename(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = this.getNode(context);
            boolean bl = model.getXmlMetadataResolver().isValueModifable(node);
            return bl;
        }
        finally {
            model.releaseReadLock();
        }
    }

    @Override
    protected CommandResult renameImpl(final DependencyContext context, final ValueInfo value) {
        CommandResult result = new CommandResult();
        final XmlContext xmlContext = this.getXmlContext(context);
        Object prop = context.getTransientProperty("transactionToken");
        final TransactionToken token = prop != null ? (TransactionToken)prop : null;
        List<Reference> refs = null;
        prop = context.getTransientProperty("handlerUsages");
        if (prop != null) {
            refs = (List<Reference>)prop;
        } else {
            FindUsagesCallback callback = new FindUsagesCallback();
            this.findUsages(context, callback);
            refs = callback.getReferences();
        }
        boolean didTxn = new NonValidatingTransactionTask(){

            @Override
            protected final String getTransactionNameWithoutModelAccess() {
                return "Rename operation";
            }

            @Override
            protected final String computeTransactionName(AbstractModel model) {
                return null;
            }

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (token != null) {
                    xmlContext.setTransactionToken(token);
                }
                XmlDeclaration.this.updateValue(context, value);
            }
        }.run(xmlContext.getModel());
        if (didTxn) {
            boolean canUpdate = true;
            Boolean bSkipUpdate = (Boolean)context.getTransientProperty("skipUpdate");
            boolean skipUpdate = bSkipUpdate != null ? bSkipUpdate : false;
            ListIterator<Reference> itr_r = refs.listIterator(refs.size());
            while (itr_r.hasPrevious()) {
                Reference ref = itr_r.previous();
                if (!ref.supportsCommand(context, "updateReferenceCommand")) {
                    canUpdate = false;
                    if (skipUpdate) continue;
                    String format = xmlContext.getTranslatedString("REFERENCE_NO_UPDATE");
                    result.addIssue(Severity.ADVISORY, FastMessageFormat.formatMessage(format, (String)ref.getMetadata(context, "displayNameMetadata")));
                    continue;
                }
                if (!canUpdate) continue;
                try {
                    CommandResult updateResult = ref.performCommand(context, "updateReferenceCommand", value);
                    if (updateResult.getResult() == Severity.OK) continue;
                    result.addIssues(updateResult.getIssueList());
                    token.setAbortOnCompletion();
                }
                catch (Exception e) {
                    result.addIssue(Severity.ERROR, e.getMessage());
                    token.setAbortOnCompletion();
                }
                break;
            }
        }
        return result;
    }

    @Override
    protected boolean supportsGotoSelf() {
        return true;
    }

    @Override
    protected CommandResult gotoSelfImpl(DependencyContext context) {
        context.gotoDeclRef(this.getXmlContext(context), this.getNode(context));
        return CommandResult.OK;
    }

    protected final XmlContext getXmlContext(DependencyContext context) {
        return this._xmlContextRef.getXmlContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Node getNode(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = (Node)this._weakNode.get();
            if (node == null || !DomUtils.isNodeOrDescendant((Node)node, (Node)model.getDocument())) {
                node = DependencyUtils.getNodeFromInfo(this.getXmlContext(context), this._nodePath, this._attributeNS, this._attribute);
                this._weakNode = new WeakReference<Node>(node);
            }
            Node node2 = node;
            return node2;
        }
        finally {
            model.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getValue(DependencyContext context) {
        XmlModel model = this.getXmlContext(context).getModel();
        model.acquireReadLock();
        try {
            Node node = this.getNode(context);
            String textValue = DomUtils.getTextNodeValue((Node)node);
            String string = textValue.substring(this._start, this._end);
            return string;
        }
        finally {
            model.releaseReadLock();
        }
    }

    protected final int getStartIndex() {
        return this._start;
    }

    protected final int getEndIndex() {
        return this._end;
    }

    protected final void updateValue(DependencyContext context, ValueInfo value) {
        Node node = this.getNode(context);
        String currValue = DomUtils.getTextNodeValue((Node)node);
        StringBuilder builder = new StringBuilder(currValue);
        builder.replace(this._start, this._end, value.getNewValue());
        if (node instanceof Attr) {
            node.setNodeValue(builder.toString());
        } else {
            DomUtils.setTextNodeValue((Node)node, (String)builder.toString());
        }
        this._end = this._start + value.getNewValue().length();
    }
}

