/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import oracle.bali.xml.model.dependency.ResultIssue;
import oracle.bali.xml.model.dependency.ResultIssueList;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;

public class ValidationResult {
    public static final ValidationResult OK = new ValidationResult();
    private ResultIssueList _issuesList;

    public ValidationResult() {
    }

    public ValidationResult(Severity severity, String message) {
        this.addIssue(severity, message);
    }

    public ValidationResult(Issue issue) {
        this.addIssue(issue);
    }

    public void addIssue(Severity severity, String message) {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        this._issuesList.addIssue(new ResultIssue(severity, message));
    }

    public void addIssue(Issue issue) {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        this._issuesList.addIssue(issue);
    }

    public void addIssues(IssueList list) {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        for (Issue issue : list) {
            this._issuesList.addIssue(new ResultIssue(issue.getSeverity(), issue.getMessage()));
        }
    }

    public Severity getResult() {
        return this._issuesList != null ? this._issuesList.getSeverity() : Severity.OK;
    }

    public IssueList getIssueList() {
        if (this._issuesList == null) {
            this._issuesList = new ResultIssueList();
        }
        return this._issuesList;
    }
}

