/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.datatransfer.operation.AbstractSingleFlavorOperation;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;

public abstract class AbstractPositionTargetingOperation
extends AbstractSingleFlavorOperation {
    @Override
    protected List getApplicableDataAndPositionsImpl(AbstractModel model, List positions, List dataInfos) {
        ArrayList<DataAndPositions> ret = new ArrayList<DataAndPositions>(dataInfos.size());
        for (TransferDataInfo info : dataInfos) {
            Object datum = null;
            try {
                datum = info.getData(FetchMode.NO_SIDE_EFFECTS, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.isValidData(model, info, datum)) continue;
            HashSet<DomPosition> alreadyUsed = new HashSet<DomPosition>(17);
            ArrayList<DomPosition> validPositions = new ArrayList<DomPosition>(positions.size());
            for (DomPosition originalPos : positions) {
                DomPosition pos = this.convertPosition(model, originalPos, datum);
                Boolean isValidPosition = false;
                if (model.transformModelAndDomPosition()) {
                    if (model.transformDomPosition(pos) == null) {
                        isValidPosition = this.isValidPosition(model, pos, info, datum);
                    } else {
                        AbstractModel transformDropModel = model.transformModel();
                        DomPosition transformDropPosition = model.transformDomPosition(pos);
                        isValidPosition = this.isValidPosition(transformDropModel, transformDropPosition, info, datum);
                    }
                } else {
                    isValidPosition = this.isValidPosition(model, pos, info, datum);
                }
                if (pos == null || !alreadyUsed.add(pos) || !isValidPosition.booleanValue()) continue;
                validPositions.add(pos);
            }
            if (validPositions.isEmpty()) continue;
            validPositions.trimToSize();
            ret.add(new DataAndPositions(info, validPositions));
        }
        return ret;
    }

    protected boolean isValidData(AbstractModel model, TransferDataInfo info, Object datum) {
        return true;
    }

    protected boolean isValidPosition(AbstractModel model, DomPosition pos, TransferDataInfo info, Object datum) {
        return true;
    }

    protected DomPosition convertPosition(AbstractModel model, DomPosition originalPos, Object datum) {
        return originalPos;
    }
}

