/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.creatable;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

public class XmlCreationResult {
    public static final XmlCreationResult NO_OP_RESULT = new XmlCreationResult(null);
    private final List<Node> _createdNodes;

    public static final XmlCreationResult getSimpleResult(List<Node> createdNodes) {
        return new XmlCreationResult(createdNodes);
    }

    public static final XmlCreationResult getSimpleResult(Node node) {
        List<Node> createdNodes = null;
        if (node != null) {
            createdNodes = Collections.singletonList(node);
        }
        return new XmlCreationResult(createdNodes);
    }

    public final List<Node> getCreatedNodes() {
        return this._createdNodes;
    }

    public Node getFirstCreatedNode() {
        List<Node> createdNodes = this.getCreatedNodes();
        Node firstNode = null;
        if (!createdNodes.isEmpty()) {
            firstNode = createdNodes.get(0);
        }
        return firstNode;
    }

    protected XmlCreationResult(List<Node> createdNodes) {
        this._createdNodes = createdNodes != null ? Collections.unmodifiableList(createdNodes) : Collections.emptyList();
    }
}

