/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.creatable;

import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlUsage;
import org.w3c.dom.Node;

public class XmlCreationContext {
    public static final String USAGE_PALETTE = "xmlef-palette";
    public static final String USAGE_INSERTION_MENU = "xmlef-insertion-menu";
    public static final String USAGE_MODEL = "xmlef-model";
    private final AbstractModel _model;
    private final String _usage;
    private final DomPosition _domPosition;
    private final XmlKey _parentKey;
    private final XmlUsage _editorUsage;

    public static final XmlCreationContext create(AbstractModel model, String usage) {
        return XmlCreationContext.create(model, usage, null, null);
    }

    public static final XmlCreationContext create(AbstractModel model, String usage, XmlUsage editorUsage) {
        return XmlCreationContext.createForEditor(model, usage, editorUsage);
    }

    public static final XmlCreationContext create(AbstractModel model, String usage, DomPosition domPosition) {
        return XmlCreationContext.create(model, usage, domPosition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XmlCreationContext create(AbstractModel model, String usage, DomPosition domPosition, XmlKey parentKey) {
        Node containerNode;
        if (domPosition != null && parentKey == null && (containerNode = domPosition.getContainerNode()) != null) {
            model.acquireReadLock();
            try {
                parentKey = model.getNodeXmlKey(containerNode);
            }
            finally {
                model.releaseReadLock();
            }
        }
        return new XmlCreationContext(model, usage, domPosition, parentKey, null);
    }

    private static XmlCreationContext createForEditor(AbstractModel model, String usage, XmlUsage editorUsage) {
        return new XmlCreationContext(model, usage, null, null, editorUsage);
    }

    public final AbstractModel getModel() {
        return this._model;
    }

    public final XmlMetadataResolver getMetadataResolver() {
        return this.getModel().getXmlMetadataResolver();
    }

    public final DomPosition getDomPosition() {
        return this._domPosition;
    }

    public final XmlKey getParentKey() {
        return this._parentKey;
    }

    public final String getUsage() {
        return this._usage;
    }

    public final XmlUsage getEditorUsage() {
        return this._editorUsage;
    }

    public final boolean matchesUsage(String usage) {
        return this._usage.equals(usage);
    }

    private XmlCreationContext(AbstractModel model, String usage, DomPosition domPosition, XmlKey parentKey, XmlUsage editorUsage) {
        if (model == null || usage == null) {
            throw new IllegalArgumentException("XmlCreationContext requires a non-null model and usage");
        }
        this._model = model;
        this._usage = usage;
        this._domPosition = domPosition;
        this._parentKey = parentKey;
        this._editorUsage = editorUsage;
    }
}

