/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.contract;

import java.util.concurrent.ConcurrentHashMap;

public class ContractIdentifier
implements Comparable {
    private static ConcurrentHashMap<String, ContractIdentifier> _sContractIdentifierMap = new ConcurrentHashMap(37, 0.75f, 3);
    private final String _identifier;
    private final int _hashCode;

    public static ContractIdentifier getContractIdentifier(String contractName) {
        ContractIdentifier newIdentifier;
        if (!ContractIdentifier.isValidIdentifier(contractName)) {
            throw new IllegalArgumentException("The contract identifier is not valid: " + contractName);
        }
        ContractIdentifier identifier = _sContractIdentifierMap.get(contractName);
        if (identifier == null && (identifier = _sContractIdentifierMap.putIfAbsent(contractName, newIdentifier = new ContractIdentifier(contractName))) == null) {
            identifier = newIdentifier;
        }
        return identifier;
    }

    public static boolean isValidIdentifier(String contractName) {
        return contractName != null && contractName.length() != 0;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        ContractIdentifier testObj = (ContractIdentifier)o;
        return this._identifier.compareTo(testObj._identifier);
    }

    public String toString() {
        return this._identifier;
    }

    private ContractIdentifier(String identifier) {
        this._identifier = identifier;
        this._hashCode = this._identifier.hashCode();
    }
}

