/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.JTextField;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;

final class TextFieldSupport {
    private TextFieldSupport() {
    }

    public static EditorComponentInfo getTextFieldInfo(AttributeValueItemPropertyEditor propEditor) {
        if (!TextFieldSupport._isTextField(propEditor)) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(MappedEditorFactoryInfo.EDITABLE, !TextFieldSupport._isDisabled(propEditor));
        return EditorUtils.createEditorComponentInfo(MappedEditorFactoryInfo.TEXT_FIELD, properties);
    }

    private static boolean _isDisabled(AttributeValueItemPropertyEditor propEditor) {
        return propEditor.getRow().inlineEditingDisabled();
    }

    public static void initializeJTextField(JTextField jtf, AttributeValueItemPropertyEditor propEditor) {
        TextFieldSupport._setNonFocusedState(jtf, propEditor);
    }

    private static boolean _isTextField(AttributeValueItemPropertyEditor propEditor) {
        String identifier = propEditor.__getBaseEditorComponentIdentifier();
        if (identifier == null) {
            return true;
        }
        return identifier.equals(MappedEditorFactoryInfo.TEXT_FIELD);
    }

    private static void _setNonFocusedState(JTextField jtf, AttributeValueItemPropertyEditor propEditor) {
        String propValue = propEditor.__getAsTextOrNull();
        if (propValue != null) {
            jtf.setText(propValue);
        } else {
            jtf.setText(propEditor.__getAsTextOrDefault());
        }
    }

    private static void _changeUiForDefault(JTextField jtf, boolean isDefault) {
        if (isDefault) {
            jtf.setForeground(Color.GRAY);
        } else {
            jtf.setForeground(jtf.getForeground());
        }
    }
}

