/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.BaseXmlKeyPropertyRowCreator;
import oracle.bali.xml.gui.base.inspector.PresenceBooleanPropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.DomNodeXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SimpleElementPropertyRowCreator
extends BaseXmlKeyPropertyRowCreator<Node> {
    SimpleElementPropertyRowCreator() {
    }

    @Override
    protected List<XmlKey> getGrammarBasedKeys(BaseInspectorGui gui, PropertyRowOwner owner) {
        Node ownerNode = owner.getParentNode();
        XmlKey ownerKey = owner.getParentKey();
        HashSet<XmlKey> set = new HashSet<XmlKey>();
        XmlMetadataResolver resolver = gui.getView().getXmlMetadataResolver();
        if (ownerNode != null && resolver.isTextDisplayedAsAttribute(ownerNode) || ownerNode == null && resolver.isTextDisplayedAsAttribute(ownerKey)) {
            set.add(ownerKey);
        } else if (ownerNode != null && !DomUtils.isInDocumentHierarchy((Node)ownerNode) && resolver.isTextDisplayedAsAttribute(ownerKey)) {
            set.add(ownerKey);
        }
        set.addAll(this._getGrammarKeys(gui, ownerKey));
        return new ArrayList<XmlKey>(set);
    }

    @Override
    protected Map<XmlKey, Node> getModelObjects(BaseInspectorGui gui, PropertyRowOwner owner) {
        Node parentNode = owner.getParentNode();
        if (parentNode == null) {
            return Collections.emptyMap();
        }
        HashMap<XmlKey, Node> map = new HashMap<XmlKey, Node>();
        for (Node child = parentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!DomUtils.isElement((Node)child)) continue;
            XmlKey key = null;
            GrammarResolver gr = gui.getGuiContext().getGrammarResolver();
            key = DomUtils.isInDocumentHierarchy((Node)child) ? DomNodeXmlKey.createImmutableXmlKey((GrammarResolver)gr, (Node)child) : DerivedXmlKey.createElementKey((GrammarResolver)gr, (XmlKey)owner.getParentKey(), (Element)((Element)child));
            map.put(key, child);
        }
        return map;
    }

    @Override
    protected PropertyRow createRow(BaseInspectorGui gui, PropertyRowOwner owner, XmlKey key, XmlKey grammarInfo, Node node) {
        if (grammarInfo == null) {
            return null;
        }
        Node ownerNode = owner.getParentNode();
        XmlKey ownerKey = owner.getParentKey();
        boolean useAbsPres = this._useAbsencePresence(gui, key, node);
        if (key.equals((Object)ownerKey)) {
            key = ownerKey;
            node = ownerNode;
        }
        if (useAbsPres) {
            return new PresenceBooleanPropertyRow(gui, node, key, owner);
        }
        return gui.createSimpleElementPropertyRow(key, node, owner);
    }

    @Override
    protected boolean supportsAnyProperties(BaseInspectorGui gui, PropertyRowOwner owner) {
        return DomUtils.isElement((Node)owner.getTargetNode());
    }

    private boolean _useAbsencePresence(BaseInspectorGui gui, XmlKey key, Node node) {
        GrammarComponent gc;
        XmlMetadataResolver resolver = gui.getView().getXmlMetadataResolver();
        String vads = node != null ? resolver.getVirtualAttributeDataSource(node) : resolver.getVirtualAttributeDataSource(key);
        if ("##presence".equals(vads) || "##propertiesAndPresence".equals(vads)) {
            return true;
        }
        if (vads == null && (gc = resolver.getGrammarComponent(key)) instanceof ElementDef) {
            ElementDef ed = (ElementDef)gc;
            Type type = ed.getType();
            return type != null && type.getVariety() == 6;
        }
        return false;
    }

    private List<XmlKey> _getGrammarKeys(BaseInspectorGui gui, XmlKey ownerKey) {
        XmlMetadataResolver resolver = gui.getView().getXmlMetadataResolver();
        Set<XmlKey> children = resolver.getVirtualAttributeKeys(ownerKey);
        ArrayList<XmlKey> nonVadsChildren = new ArrayList<XmlKey>(children.size());
        for (XmlKey k : children) {
            String vads = resolver.getVirtualAttributeDataSource(k);
            if (vads != null && vads.equals("##properties")) continue;
            nonVadsChildren.add(k);
        }
        return nonVadsChildren;
    }
}

