/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import java.util.HashMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.proxy.ContainerViewNode;
import oracle.bali.xml.dom.view.proxy.Dual;
import oracle.bali.xml.dom.view.proxy.ViewAttr;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ViewElement
extends ContainerViewNode
implements Element {
    private DelegatingNamedNodeMap _attrMap;

    ViewElement(Node proxiedNode) {
        super(proxiedNode);
    }

    @Override
    public String getNodeName() {
        Element proxiedElement = this.getProxiedElement();
        if (proxiedElement != null) {
            return proxiedElement.getNodeName();
        }
        String prefix = this.getPrefix();
        int prefixLength = prefix != null ? prefix.length() : 0;
        String localName = this.getLocalName();
        if (prefixLength != 0) {
            int bufferSize = localName.length() + prefixLength + 1;
            StringBuffer buffer = new StringBuffer(bufferSize);
            buffer.append(prefix);
            buffer.append(':');
            buffer.append(localName);
            return buffer.toString();
        }
        return localName;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (nodeValue != null) {
            throw new DOMException(7, "Elements can not have node values");
        }
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public String getAttribute(String name) {
        Attr attributeNode = this.getAttributeNode(name);
        if (attributeNode != null) {
            return attributeNode.getNodeValue();
        }
        return "";
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.getAttributes().getNamedItem(name);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return null;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return "";
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return (Attr)this.getAttributes().getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw this.getNoModificationException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.hasAttributeNS(null, name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this._getAttrMap().hasNodeNS(namespaceURI, localName);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this._getAttrMap();
    }

    @Override
    public boolean hasAttributes() {
        return this._getAttrMap().getLength() != 0;
    }

    protected Element getProxiedElement() {
        return DomUtils.asElement((Node)this.getProxiedNode());
    }

    private DelegatingNamedNodeMap _getAttrMap() {
        if (this._attrMap == null) {
            this._attrMap = new DelegatingNamedNodeMap(this.getProxiedNode().getAttributes());
        }
        return this._attrMap;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        this.__nyi();
        return null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.__nyi();
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.__nyi();
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.__nyi();
    }

    private class DelegatingNamedNodeMap
    implements NamedNodeMap {
        private HashMap _attrs = null;
        private NamedNodeMap _proxiedMap;

        public DelegatingNamedNodeMap(NamedNodeMap proxiedMap) {
            this._proxiedMap = proxiedMap;
        }

        private NamedNodeMap _getProxiedMap() {
            return this._proxiedMap;
        }

        @Override
        public Node getNamedItem(String name) {
            return this.getNamedItemNS(null, name);
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            throw ViewElement.this.getNoModificationException();
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            throw ViewElement.this.getNoModificationException();
        }

        @Override
        public Node item(int index) {
            Node attr = this._getProxiedMap().item(index);
            Object key = null;
            if (attr != null) {
                Node proxiedAttr;
                if (this._attrs != null && (proxiedAttr = (Node)this._attrs.get(key = this._getAttrKey(attr.getNamespaceURI(), DomUtils.getLocalName((Node)attr)))) != null) {
                    return proxiedAttr;
                }
                attr = this._createViewAttr(key, attr);
            }
            return attr;
        }

        @Override
        public int getLength() {
            return this._getProxiedMap().getLength();
        }

        public boolean hasNodeNS(String namespaceURI, String localName) {
            return this._getProxiedMap().getNamedItemNS(namespaceURI, localName) != null;
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) {
            Node attrNode = null;
            Object key = null;
            if (this._attrs != null && (attrNode = (Node)this._attrs.get(key = this._getAttrKey(namespaceURI, localName))) != null) {
                return attrNode;
            }
            attrNode = this._getProxiedMap().getNamedItemNS(namespaceURI, localName);
            if (attrNode != null) {
                attrNode = this._createViewAttr(key, attrNode);
            }
            return attrNode;
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            throw ViewElement.this.getNoModificationException();
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw ViewElement.this.getNoModificationException();
        }

        private ViewAttr _createViewAttr(Object key, Node proxiedAttr) {
            ViewAttr attr = new ViewAttr(proxiedAttr);
            attr.setParentNode(ViewElement.this);
            attr.setViewDocument(ViewElement.this.getViewDocument());
            if (key == null) {
                String namespace = proxiedAttr.getNamespaceURI();
                String localName = DomUtils.getLocalName((Node)proxiedAttr);
                key = this._getAttrKey(namespace, localName);
            }
            if (this._attrs == null) {
                this._attrs = new HashMap((int)((double)this._getProxiedMap().getLength() * 1.25));
            }
            this._attrs.put(key, attr);
            return attr;
        }

        private Object _getAttrKey(String namespaceURI, String localName) {
            Object key = localName;
            if (namespaceURI != null) {
                key = new Dual(namespaceURI, localName);
            }
            return key;
        }
    }
}

