/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.changes;

import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NodeRefFactory;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractAttrChange
extends DomChange {
    private final NodeRef _attrRef;
    private final NodeRef _ownerElementRef;
    private final Attr _attr;

    protected AbstractAttrChange(Attr attr, Node owner) {
        this(attr, NodeRefFactory.getNodeRef((Node)owner));
    }

    protected AbstractAttrChange(Attr attr, NodeRef ownerElementRef) {
        this._attrRef = NodeRefFactory.getAttrRef((NodeRef)ownerElementRef, (Attr)attr);
        this._ownerElementRef = ownerElementRef;
        this._attr = (Attr)AbstractAttrChange.cloneNode(attr);
    }

    @Override
    public final NodeRef getNodeRef() {
        return this._attrRef;
    }

    public final NodeRef getOwnerElementRef() {
        return this._ownerElementRef;
    }

    public final String getAffectedAttrLocalName() {
        return DomUtils.getLocalName((Node)this._attr);
    }

    public final String getAffectedAttrNamespace() {
        return this._attr.getNamespaceURI();
    }

    public Element getOwnerElement(Document doc) {
        Node parent = this._ownerElementRef.getCorrespondingNode(doc);
        if (parent != null && parent.getNodeType() == 1) {
            Element parentElement = (Element)parent;
            return parentElement;
        }
        throw new IllegalStateException("Parent element of attribute " + this._attr + " not found along given path in document " + doc);
    }

    protected final Attr getAffectedAttrClone() {
        return this._attr;
    }
}

