/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.BackwardsBiasedSimpleLocator;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.DocumentTypeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.EntityRefLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.javatools.buffer.LineMap;

public class LocatorManager {
    private LinkedHashSet _locatorSet;
    private LineMap _lineMap;
    private static final Logger _LOGGER = Logger.getLogger(LocatorManager.class.getName());

    public LocatorManager(LineMap lineMap) {
        this._lineMap = lineMap;
        this._createLocatorSet();
    }

    public SimpleLocator createSimpleLocator(int startOffset, int endOffset) {
        return this.createSimpleLocator(startOffset, endOffset, true);
    }

    public SimpleLocator createSimpleLocator(int startOffset, int endOffset, boolean attach) {
        SimpleLocator locator = new SimpleLocator(this._lineMap, startOffset, endOffset);
        if (attach) {
            this.attach(locator);
        }
        return locator;
    }

    public SimpleLocator createBackwardsBiasedSimpleLocator(int startOffset, int endOffset, boolean attach) {
        BackwardsBiasedSimpleLocator locator = new BackwardsBiasedSimpleLocator(this._lineMap, startOffset, endOffset);
        if (attach) {
            this.attach(locator);
        }
        return locator;
    }

    public EntityRefLocator createEntityRefLocator(int startOffset, int endOffset, String entityRefText, String replacementText, boolean attach) {
        EntityRefLocator locator = new EntityRefLocator(this._lineMap, startOffset, endOffset, entityRefText, replacementText);
        if (attach) {
            this.attach(locator);
        }
        return locator;
    }

    public ElementLocator createElementLocator(SimpleLocator startTagLocator) {
        return this.createElementLocator(startTagLocator, null);
    }

    public ElementLocator createElementLocator(SimpleLocator startTagLocator, SimpleLocator nameLocator) {
        return this.createElementLocator(startTagLocator, nameLocator, null);
    }

    public ElementLocator createElementLocator(SimpleLocator startTagLocator, SimpleLocator nameLocator, SimpleLocator endTagLocator) {
        ElementLocator elementLocator = new ElementLocator(this._lineMap, startTagLocator);
        if (nameLocator != null) {
            elementLocator.setNameLocator(nameLocator);
        }
        if (endTagLocator != null) {
            elementLocator.setEndTagLocator(endTagLocator);
        }
        return elementLocator;
    }

    public DeclarationLocator createDeclarationLocator(SimpleLocator declarationLocator) {
        return this.createDeclarationLocator(declarationLocator, null, null, null);
    }

    public DeclarationLocator createDeclarationLocator(SimpleLocator declarationLocator, AttributeLocator versionLocator, AttributeLocator encodingLocator, AttributeLocator standaloneLocator) {
        DeclarationLocator declLocator = new DeclarationLocator(this._lineMap, declarationLocator);
        declLocator.setVersionLocator(versionLocator);
        declLocator.setEncodingLocator(encodingLocator);
        declLocator.setStandaloneLocator(standaloneLocator);
        return declLocator;
    }

    public DocumentTypeLocator createDocumentTypeLocator(SimpleLocator documentTypeLocator) {
        return this.createDocumentTypeLocator(documentTypeLocator, null, null);
    }

    public DocumentTypeLocator createDocumentTypeLocator(SimpleLocator documentTypeLocator, SimpleLocator publicIdLocator, SimpleLocator systemIdLocator) {
        DocumentTypeLocator docTypeLocator = new DocumentTypeLocator(this._lineMap, documentTypeLocator);
        docTypeLocator.setPublicIdLocator(publicIdLocator);
        docTypeLocator.setSystemIdLocator(systemIdLocator);
        return docTypeLocator;
    }

    public AttributeLocator createAttributeLocator(SimpleLocator nameLocator) {
        return this.createAttributeLocator(nameLocator, null, null, (short)2, (short)3);
    }

    public AttributeLocator createAttributeLocator(SimpleLocator nameLocator, SimpleLocator equalsLocator, TextLocator valueLocator, short quoteStyle, short quoteUsage) {
        AttributeLocator attrLocator = new AttributeLocator(this._lineMap, nameLocator);
        if (equalsLocator != null) {
            attrLocator.setEqualsLocator(equalsLocator);
        }
        if (valueLocator != null) {
            attrLocator.setValueLocator(valueLocator);
            attrLocator.setQuoteStyle(quoteStyle);
            attrLocator.setQuoteUsage(quoteUsage);
        }
        return attrLocator;
    }

    public AttributeLocator createUnspecifiedAttributeLocator(int offset) {
        SimpleLocator nameLocator = this.createSimpleLocator(offset, offset);
        SimpleLocator equalsLocator = this.createSimpleLocator(offset, offset);
        SimpleLocator valueLocator = this.createSimpleLocator(offset, offset);
        TextLocator textLocator = this.createTextLocator(Collections.singletonList(valueLocator));
        AttributeLocator attrLocator = this.createAttributeLocator(nameLocator, equalsLocator, textLocator, (short)2, (short)3);
        attrLocator.setSpecified(false);
        return attrLocator;
    }

    public TextLocator createTextLocator(List contentLocators, List whitespaceLocators) {
        return new TextLocator(this.getLineMap(), contentLocators, whitespaceLocators);
    }

    public TextLocator createTextLocator(List contentLocators) {
        return this.createTextLocator(contentLocators, Collections.EMPTY_LIST);
    }

    public void attach(SimpleLocator locator, boolean attach) {
        if (attach) {
            this.attach(locator);
        } else {
            this.detach(locator);
        }
    }

    public void attach(SimpleLocator locator) {
        if (locator != null) {
            this._locatorSet.add(locator);
        }
    }

    public void detach(SimpleLocator locator) {
        if (locator != null) {
            this._locatorSet.remove(locator);
        }
    }

    public boolean isAttached(SimpleLocator locator) {
        return this._locatorSet.contains(locator);
    }

    public void charactersAdded(int offset, int length) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "LM: charactersAdded; offset={0} length={1}", new Object[]{String.valueOf(offset), String.valueOf(length)});
        }
        for (SimpleLocator locator : this._locatorSet) {
            locator.adjustForCharactersAdded(offset, length);
        }
    }

    public void charactersRemoved(int offset, int length) {
        if (_LOGGER.isLoggable(Level.FINEST)) {
            _LOGGER.log(Level.FINEST, "LM: charactersRemoved; offset={0} length={1}", new Object[]{String.valueOf(offset), String.valueOf(length)});
        }
        Iterator iter = this._locatorSet.iterator();
        while (iter.hasNext()) {
            SimpleLocator locator = (SimpleLocator)iter.next();
            boolean shouldDetach = locator.adjustForCharactersRemoved(offset, length);
            if (!shouldDetach) continue;
            iter.remove();
        }
    }

    public void charactersAdded(Locator newLocator) {
        newLocator.attach(this, false);
        this.charactersAdded(newLocator.getStartOffset(), newLocator.getLength());
        newLocator.attach(this, true);
    }

    public void charactersRemoved(Locator oldLocator) {
        oldLocator.attach(this, false);
        this.charactersRemoved(oldLocator.getStartOffset(), oldLocator.getLength());
    }

    public void locatorLengthChanged(SimpleLocator locator, int newLength) {
        int startOffset = locator.getStartOffset();
        int oldEndOffset = locator.getEndOffset();
        int newEndOffset = startOffset + newLength;
        locator.setEndOffset(newEndOffset);
        this.detach(locator);
        if (newEndOffset > oldEndOffset) {
            this.charactersAdded(oldEndOffset, newEndOffset - oldEndOffset);
        } else if (newEndOffset < oldEndOffset) {
            this.charactersRemoved(newEndOffset, oldEndOffset - newEndOffset);
        }
        this.attach(locator);
    }

    public void addEndTagAtLocator(ElementLocator elementLocator, SimpleLocator newEndTagLocator) {
        this.charactersAdded(newEndTagLocator);
        elementLocator.setEndTagLocator(newEndTagLocator);
    }

    public void removeEndTagAtLocator(ElementLocator elementLocator) {
        SimpleLocator endTagLocator = elementLocator.getEndTagLocator();
        elementLocator.setEndTagLocator(null);
        if (endTagLocator != null) {
            this.charactersRemoved(endTagLocator);
        }
    }

    public void addSlashAtLocator(ElementLocator elementLocator, SimpleLocator newSlashLocator) {
        this.charactersAdded(newSlashLocator);
        elementLocator.setSlashLocator(newSlashLocator);
    }

    public void removeSlashAtLocator(ElementLocator elementLocator) {
        SimpleLocator slashLocator = elementLocator.getSlashLocator();
        elementLocator.setSlashLocator(null);
        if (slashLocator != null) {
            this.charactersRemoved(slashLocator);
        }
    }

    public final LineMap getLineMap() {
        return this._lineMap;
    }

    public final void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public void clear() {
        this._locatorSet.clear();
    }

    protected void _createLocatorSet() {
        this._locatorSet = new LinkedHashSet(256);
    }

    private String _setQuoteStyle(AttributeLocator attrLocator, String attributeValue) {
        int valueStartOffset = 0;
        int valueEndOffset = attributeValue.length();
        short quoteStyle = 2;
        short quoteUsage = 3;
        if (valueEndOffset - valueStartOffset >= 1) {
            char firstChar = attributeValue.charAt(valueStartOffset);
            if (firstChar == '\"') {
                quoteStyle = 1;
            } else if (firstChar == '\'') {
                quoteStyle = 0;
            }
            if (quoteStyle != 2) {
                quoteUsage = 2;
                ++valueStartOffset;
            }
        }
        if (valueEndOffset - valueStartOffset >= 1) {
            char lastChar = attributeValue.charAt(valueEndOffset - 1);
            if (lastChar == '\"') {
                if (quoteStyle == 1) {
                    quoteUsage = 0;
                } else if (quoteStyle == 2) {
                    quoteStyle = 1;
                    quoteUsage = 1;
                }
            } else if (lastChar == '\'') {
                if (quoteStyle == 0) {
                    quoteUsage = 0;
                } else if (quoteStyle == 2) {
                    quoteStyle = 0;
                    quoteUsage = 1;
                }
            }
            if (quoteUsage == 0 || quoteUsage == 1) {
                --valueEndOffset;
            }
        }
        String strippedAttributeValue = attributeValue.substring(valueStartOffset, valueEndOffset);
        if (attrLocator != null) {
            attrLocator.setQuoteStyle(quoteStyle);
            attrLocator.setQuoteUsage(quoteUsage);
        }
        return strippedAttributeValue;
    }
}

