/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.buffer.AbstractBufferDomParser;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.DocumentTypeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.SimulateInsertingFragmentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BufferDomFragmentParser
extends AbstractBufferDomParser {
    private Document _document = null;
    private TreeTraversal _traversal = null;
    private DocumentFragment _fragment = null;
    private Element _contextElement = null;

    public BufferDomFragmentParser(DOMImplementation domImpl, ParserConfiguration parserConfiguration, DocumentScannerFactory documentScannerFactory, WhitespaceHandler whitespaceHandler) {
        super(domImpl, parserConfiguration, documentScannerFactory, whitespaceHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFragment parseFragment(Document ownerDoc, Node contextNode, Map predefinedPrefixes, String text) {
        if (ownerDoc == null) {
            throw new IllegalArgumentException("null owner document");
        }
        if (text == null) {
            throw new IllegalArgumentException("null text");
        }
        ReadTextBuffer buffer = TextBufferFactory.createReadTextBuffer((String)text);
        LocatorManager bogusManager = new LocatorManager(null);
        HashMap bogusMap = new HashMap();
        this._document = ownerDoc;
        this._fragment = ownerDoc.createDocumentFragment();
        this._traversal = DocumentTreeTraversal.INSTANCE;
        this._contextElement = null;
        DocumentFragment ret = null;
        try {
            NamespaceDeclarations nds;
            if (contextNode == null) {
                nds = null;
                this._traversal = DocumentTreeTraversal.INSTANCE;
            } else {
                HashMap nsMap = new HashMap(27);
                if (DomUtils.isElement((Node)contextNode)) {
                    this._contextElement = (Element)contextNode;
                    this._traversal = new SimulateInsertingFragmentTreeTraversal(this._contextElement, this._fragment);
                }
                nsMap.putAll(this.getParserConfiguration().getPrefixesInScope(contextNode));
                nsMap.putAll(predefinedPrefixes);
                nds = new NamespaceDeclarations();
                for (Map.Entry entry : nsMap.entrySet()) {
                    String prefix = (String)entry.getKey();
                    String ns = (String)entry.getValue();
                    NamespaceDeclaration decl = "".equals(prefix) ? new NamespaceDeclaration(ns, -1) : new NamespaceDeclaration(ns, prefix, -1);
                    nds.addNamespaceDeclaration(decl);
                }
            }
            this.doParse(buffer, bogusManager, bogusMap, this._fragment, nds);
        }
        finally {
            ret = this._fragment;
            this._fragment = null;
            this._document = null;
            this._traversal = null;
            this._contextElement = null;
            this.doCleanup();
        }
        return ret;
    }

    @Override
    protected Document getOwnerDocument() {
        return this._document;
    }

    @Override
    protected void handleDocumentScannerException() {
        this._document = null;
        this._fragment = null;
    }

    @Override
    protected void handleCommentOrPIBeforeDocumentCreated(Node node, Locator locator) {
        throw new IllegalStateException("impossible, since fragment parser always has a document");
    }

    @Override
    protected Element handleElementBeforeDocumentCreated(ResolvedName name, ElementLocator locator) {
        throw new IllegalStateException("impossible, since fragment parser always has a document");
    }

    @Override
    protected TreeTraversal getTraversalForWhitespaceHandler() {
        return this._traversal;
    }

    @Override
    protected Element getPotentialParentElement(Node realCurrentParent) {
        if (realCurrentParent == this._fragment) {
            return this._contextElement;
        }
        return super.getPotentialParentElement(realCurrentParent);
    }

    @Override
    protected boolean shouldCreateUnspecifiedAttributes() {
        return false;
    }

    @Override
    public void handleXMLDeclaration(String version, String encoding, String standalone, DeclarationLocator locator) {
    }

    @Override
    public void handleDocumentType(ResolvedName name, String publicID, String systemID, SimpleLocator locator, DocumentTypeLocator docTypeLocator) {
    }
}

