/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers.element;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.annotation.PropertyType;
import oracle.bali.xml.beanmodel.annotation.PropertyTypeLiteral;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.handlers.MethodInvocationHandler;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementInvocationHandler
extends MethodInvocationHandler {
    @Override
    public final PropertyType getPropertyType() {
        return new PropertyTypeLiteral("element");
    }

    @Override
    protected final Object invokeImpl(XmlBaseType proxy, Method method, Object[] args, DynamicProxyContext context) throws Throwable {
        QualifiedName childName = this.getQualifiedName(context, method, true);
        XmlKey childKey = context.getXmlModel().getElementKey(context.getXmlKey(), childName);
        List<QualifiedName> qNames = this.getQualifiedNames(childName, childKey, context);
        if (!DomUtils.isElement((Node)context.getNode())) {
            throw new IllegalStateException("Expected Element Node type but found node: " + context.getNode());
        }
        Element element = (Element)context.getNode();
        return this.invokeImpl(proxy, method, args, context, element, childKey, qNames);
    }

    protected abstract Object invokeImpl(XmlBaseType var1, Method var2, Object[] var3, DynamicProxyContext var4, Element var5, XmlKey var6, List<QualifiedName> var7) throws Throwable;

    private List<QualifiedName> getQualifiedNames(QualifiedName qName, XmlKey childKey, DynamicProxyContext context) {
        GrammarComponent component = context.getXmlModel().getGrammarComponent(childKey);
        if (component == null || !(component instanceof ElementDef)) {
            return Collections.singletonList(qName);
        }
        ArrayList<QualifiedName> qNames = new ArrayList<QualifiedName>();
        ElementDef elementDef = (ElementDef)component;
        if (!elementDef.isAbstract()) {
            qNames.add(qName);
        }
        for (Object obj : elementDef.getSubstitutionGroup().getElementDefs()) {
            ElementDef substElement = (ElementDef)obj;
            qNames.add(substElement.getQualifiedName());
        }
        return qNames;
    }
}

