/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers;

import java.lang.reflect.Method;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class XmlBaseTypeInvocationHandler {
    private static final String _METHOD_NAME_GET_DOM_NODE = "getDomNode";
    private static final String _METHOD_NAME_GET_XML_KEY = "getXmlKey";
    private static final String _METHOD_NAME_ADD_COMMENT_BEFORE = "addCommentBefore";
    private static final String _METHOD_NAME_ADD_COMMENT_AFTER = "addCommentAfter";
    private static final String _METHOD_NAME_EQUALS = "equals";
    private static final String _METHOD_NAME_HASH_CODE = "hashCode";
    private final Method _getDomNodeMethod;
    private final Method _getXmlKeyMethod;
    private final Method _equalsMethod;
    private final Method _hashCodeMethod;
    private final Method _addCommentBeforeMethod;
    private final Method _addCommentAfterMethod;

    public XmlBaseTypeInvocationHandler() {
        try {
            this._getDomNodeMethod = XmlBaseType.class.getDeclaredMethod(_METHOD_NAME_GET_DOM_NODE, new Class[0]);
            this._getXmlKeyMethod = XmlBaseType.class.getDeclaredMethod(_METHOD_NAME_GET_XML_KEY, new Class[0]);
            this._addCommentBeforeMethod = XmlBaseType.class.getDeclaredMethod(_METHOD_NAME_ADD_COMMENT_BEFORE, String.class);
            this._addCommentAfterMethod = XmlBaseType.class.getDeclaredMethod(_METHOD_NAME_ADD_COMMENT_AFTER, String.class);
            this._equalsMethod = Object.class.getDeclaredMethod(_METHOD_NAME_EQUALS, Object.class);
            this._hashCodeMethod = Object.class.getDeclaredMethod(_METHOD_NAME_HASH_CODE, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("XmlBaseTypeInvocationHandler: Can't find expected Method object (see chained exception)", e);
        }
    }

    public Object invoke(XmlBaseType proxy, Method method, Object[] args, DynamicProxyContext context) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass != XmlBaseType.class && declaringClass != Object.class) {
            throw new IllegalStateException("XmlBaseTypeInvocationHandler invoked to handle method not declared on XmlBaseType");
        }
        if (this._getDomNodeMethod.equals(method)) {
            return context.getNode();
        }
        if (this._getXmlKeyMethod.equals(method)) {
            return context.getXmlKey();
        }
        if (this._addCommentBeforeMethod.equals(method) || this._addCommentAfterMethod.equals(method)) {
            if (args[0] == null) {
                throw new IllegalStateException("XmlBaseTypeInvocationHandler for addComment requires a non-null comment argument");
            }
            Node node = context.getNode();
            if (node.getParentNode() == null) {
                throw new IllegalStateException("XmlBaseTypeInvocationHandler for addComment requires a node with a parent");
            }
            DomPosition pos = this._addCommentBeforeMethod.equals(method) ? DomPositionFactory.before((Node)node) : DomPositionFactory.after((Node)node);
            Comment comment = context.getXmlModel().getDocument().createComment(args[0].toString());
            DomUtils.insertNodeAtPosition((DomPosition)pos, (Node)comment);
            return null;
        }
        if (this._equalsMethod.equals(method)) {
            Object test = args[0];
            if (test instanceof XmlBaseType) {
                XmlBaseType testType = (XmlBaseType)test;
                Node testNode = testType.getDomNode();
                return context.getNode() == testNode;
            }
            return false;
        }
        if (this._hashCodeMethod.equals(method)) {
            return context.getNode().hashCode();
        }
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)proxy, args);
        }
        throw new IllegalStateException("No invocation handler found for method: " + method);
    }
}

