/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifier;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifierException;
import oracle.bali.xml.beanmodel.annotation.Operation;
import oracle.bali.xml.beanmodel.annotation.PropertyType;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.DynamicProxyFactory;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MethodInvocationHandler {
    private static Logger _sLogger = Logger.getLogger(MethodInvocationHandler.class.getName());

    protected MethodInvocationHandler() {
    }

    public final Object invoke(XmlBaseType proxy, Method method, Object[] args, DynamicProxyContext context) throws Throwable {
        MethodIdentifier identifier = MethodIdentifier.createFromMethod((Method)method);
        if (!identifier.equals((Object)this.getMethodIdentifier())) {
            throw new IllegalStateException(this.getClass().getName() + " called to implement method with mismatched MethodIdentifier. Method= " + method + " " + identifier);
        }
        return this.invokeImpl(proxy, method, args, context);
    }

    public final MethodIdentifier getMethodIdentifier() {
        MethodIdentifier identifier;
        try {
            identifier = MethodIdentifier.create((Operation)this.getOperation(), (PropertyType)this.getPropertyType());
        }
        catch (MethodIdentifierException e) {
            throw new IllegalStateException("MethodInvocationHandler missing required MethodIdentifier information (see cause)", e);
        }
        return identifier;
    }

    public boolean isWriteMethod() {
        return !"get".equals(this.getOperation().type()) && !"isSet".equals(this.getOperation().type());
    }

    public abstract Operation getOperation();

    public abstract PropertyType getPropertyType();

    protected abstract Object invokeImpl(XmlBaseType var1, Method var2, Object[] var3, DynamicProxyContext var4) throws Throwable;

    protected QualifiedName getQualifiedName(DynamicProxyContext context, Method method, boolean throwIfMissing) {
        oracle.bali.xml.beanmodel.annotation.QualifiedName qNameAnnotation = method.getAnnotation(oracle.bali.xml.beanmodel.annotation.QualifiedName.class);
        if (qNameAnnotation != null) {
            QualifiedName qName = QualifiedName.getQualifiedName((String)qNameAnnotation.namespace(), (String)qNameAnnotation.name());
            VersionManager versionManager = context.getXmlModel().getContext().getVersionManager();
            if (versionManager != null) {
                qName = versionManager.getVersionQualifiedName(qName);
            }
            return qName;
        }
        if (throwIfMissing) {
            throw new IllegalStateException("Missing required @QualifiedName annotation on method: " + method);
        }
        return null;
    }

    protected final Object convertToSimpleReturnType(Method method, XmlModel model, XmlKey nodeToConvertKey, String stringValue) {
        return this.convertToSimpleType(method.getGenericReturnType(), model, nodeToConvertKey, stringValue);
    }

    protected final Object convertToSimpleType(Type desiredType, XmlModel model, XmlKey nodeToConvertKey, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        Class desiredClass = null;
        desiredClass = desiredType instanceof ParameterizedType ? (Class)((ParameterizedType)desiredType).getRawType() : (Class)desiredType;
        if (String.class.equals((Object)desiredClass)) {
            return stringValue;
        }
        if (desiredClass.isEnum()) {
            try {
                return this.getEnumValue(desiredClass, stringValue);
            }
            catch (IllegalStateException e) {
                _sLogger.log(Level.INFO, "Ignoring invalid enum value, returnType= " + desiredClass.getName() + ", value= " + stringValue, e);
                return null;
            }
        }
        if (nodeToConvertKey != null) {
            SimpleType simpleType;
            oracle.bali.xml.grammar.Type parentType = null;
            GrammarComponent component = model.getGrammarComponent(nodeToConvertKey);
            if (component == null) {
                return null;
            }
            if (component instanceof ElementDef) {
                parentType = ((ElementDef)component).getType();
            } else if (component instanceof AttributeDef) {
                parentType = ((AttributeDef)component).getType();
            }
            if (parentType != null && (simpleType = TypeUtils.getSimpleTypeAncestor((oracle.bali.xml.grammar.Type)parentType)) != null) {
                try {
                    Class typeArgClass;
                    boolean isEnum;
                    ParameterizedType pType;
                    Type[] typeArguments;
                    if (List.class.equals((Object)desiredClass) && desiredType instanceof ParameterizedType && (typeArguments = (pType = (ParameterizedType)desiredType).getActualTypeArguments()).length == 1 && ((isEnum = (typeArgClass = (Class)typeArguments[0]).isEnum()) || !String.class.equals((Object)typeArgClass))) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        SimpleType itemType = this._getListItemSimpleType(simpleType);
                        StringTokenizer tokenizer = new StringTokenizer(stringValue);
                        while (tokenizer.hasMoreTokens()) {
                            String item = tokenizer.nextToken();
                            if (isEnum) {
                                try {
                                    list.add(this.getEnumValue(typeArgClass, item));
                                }
                                catch (IllegalStateException e) {
                                    _sLogger.log(Level.INFO, "Ignoring invalid enum value, type= " + typeArgClass.getName() + ", value= " + item.toString(), e);
                                }
                                continue;
                            }
                            try {
                                list.add(itemType.convertToJavaType(item));
                            }
                            catch (GrammarException e) {
                                _sLogger.log(Level.INFO, "Ignoring invalid simple-type value that can't be represented as bean type.", e);
                            }
                        }
                        return list;
                    }
                    return simpleType.convertToJavaType(stringValue);
                }
                catch (GrammarException e) {
                    _sLogger.log(Level.INFO, "Ignoring invalid simple-type value that can't be represented as bean type.", e);
                    return null;
                }
            }
        }
        throw new IllegalStateException("MethodInvocationHandler.convertToSimpleReturnType can't coerce string value to type " + desiredType + ". String value=" + stringValue);
    }

    protected final Object convertToReturnType(Method method, DynamicProxyContext context, Node nodeToConvert, XmlKey nodeToConvertKey) {
        return this.convertToType(method.getGenericReturnType(), context, nodeToConvert, nodeToConvertKey);
    }

    protected final Object convertToType(Type desiredType, DynamicProxyContext context, Node nodeToConvert, XmlKey nodeToConvertKey) {
        Class desiredClass = null;
        desiredClass = desiredType instanceof ParameterizedType ? (Class)((ParameterizedType)desiredType).getRawType() : (Class)desiredType;
        if (XmlBaseType.class.isAssignableFrom(desiredClass)) {
            DynamicProxyContext newContext = new DynamicProxyContext(context.getXmlModel(), nodeToConvert, nodeToConvertKey, desiredClass.getClassLoader());
            context.addAssociatedContext(newContext);
            return DynamicProxyFactory.getInstance().createProxyInstance(newContext, desiredClass);
        }
        String stringValue = null;
        if (nodeToConvert instanceof Element) {
            stringValue = DomUtils.getTextContent((Node)nodeToConvert);
        } else if (nodeToConvert instanceof Attr) {
            stringValue = ((Attr)nodeToConvert).getValue();
        } else {
            throw new IllegalStateException("MethodInvocationHandler.convertToReturnType encountered unexpected node type: " + nodeToConvert);
        }
        if (stringValue != null) {
            return this.convertToSimpleType(desiredType, context.getXmlModel(), nodeToConvertKey, stringValue);
        }
        return null;
    }

    protected final String convertSimpleTypeToString(XmlModel model, XmlKey nodeToConvertKey, Object value) {
        SimpleType simpleType;
        if (value instanceof String) {
            return (String)value;
        }
        if (value.getClass().isEnum()) {
            return value.toString();
        }
        oracle.bali.xml.grammar.Type parentType = null;
        GrammarComponent component = model.getGrammarComponent(nodeToConvertKey);
        if (component instanceof ElementDef) {
            parentType = ((ElementDef)component).getType();
        } else if (component instanceof AttributeDef) {
            parentType = ((AttributeDef)component).getType();
        }
        if (parentType != null && (simpleType = TypeUtils.getSimpleTypeAncestor((oracle.bali.xml.grammar.Type)parentType)) != null) {
            try {
                return JavaTypeManager.getInstance().convertToString(value, simpleType);
            }
            catch (GrammarException ge) {
                _sLogger.log(Level.INFO, "Ignoring invalid simple-type value that can't be converted to string.", ge);
            }
        }
        return value.toString();
    }

    private SimpleType _getListItemSimpleType(SimpleType simpleType) {
        SimpleType itemType = null;
        if (simpleType.getVariety() == 1) {
            itemType = simpleType.getListItemType();
        } else if (simpleType.getVariety() == 2) {
            itemType = (SimpleType)simpleType.getUnionMemberTypes().get(0);
        }
        if (itemType == null) {
            return null;
        }
        if (itemType.getVariety() == 0) {
            return itemType;
        }
        return this._getListItemSimpleType(itemType);
    }

    private <E extends Enum> E getEnumValue(Class<E> clazz, String value) {
        for (Enum enumItem : (Enum[])clazz.getEnumConstants()) {
            if (!enumItem.toString().equals(value)) continue;
            return (E)enumItem;
        }
        return null;
    }
}

