/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifier;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.handlers.MethodInvocationHandler;
import oracle.bali.xml.beanmodel.impl.handlers.MethodInvocationHandlerRegistry;
import oracle.bali.xml.beanmodel.impl.handlers.XmlBaseTypeInvocationHandler;

public final class DynamicProxyFactory {
    private static final DynamicProxyFactory _sInstance = new DynamicProxyFactory();
    private static final XmlBaseTypeInvocationHandler _xmlBaseTypeHandler = new XmlBaseTypeInvocationHandler();

    public static DynamicProxyFactory getInstance() {
        return _sInstance;
    }

    public <T> T createProxyInstance(DynamicProxyContext context, Class<T> interfaceToProxy) {
        if (context.isExpired()) {
            throw new IllegalArgumentException("DynamicProxyFactory.createProxyInstance passed expired DynamicProxyContext");
        }
        if (context.getXmlModel() == null) {
            throw new IllegalArgumentException("DynamicProxyFactory.createProxyInstance passed null XmlModel");
        }
        if (context.getNode() == null) {
            throw new IllegalArgumentException("DynamicProxyFactory.createProxyInstance passed null Node");
        }
        if (context.getClassLoader() == null) {
            throw new IllegalArgumentException("DynamicProxyFactory.createProxyInstance passed null ClassLoader");
        }
        Class[] interfaces = new Class[]{interfaceToProxy};
        RegistryBasedInvocationHandler handler = new RegistryBasedInvocationHandler(context);
        Object proxyInstance = Proxy.newProxyInstance(context.getClassLoader(), interfaces, (InvocationHandler)handler);
        return interfaceToProxy.cast(proxyInstance);
    }

    private DynamicProxyFactory() {
    }

    private class RegistryBasedInvocationHandler
    implements InvocationHandler {
        private final DynamicProxyContext _context;

        public RegistryBasedInvocationHandler(DynamicProxyContext context) {
            this._context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this._context.isExpired()) {
                throw new IllegalStateException("RegistryBasedInvocationHandler called with expired DynamicProxyContext. Beans can only be used within the task they were created");
            }
            if (!(proxy instanceof XmlBaseType)) {
                throw new IllegalStateException("RegistryBasedInvocationHandler called with proxy object that does not extend from XmlBaseType");
            }
            XmlBaseType xmlBaseType = (XmlBaseType)proxy;
            if (method.getDeclaringClass() == XmlBaseType.class || method.getDeclaringClass() == Object.class) {
                return _xmlBaseTypeHandler.invoke(xmlBaseType, method, args, this._context);
            }
            MethodIdentifier methodIdentifier = MethodIdentifier.createFromMethod((Method)method);
            MethodInvocationHandler handler = MethodInvocationHandlerRegistry.getInstance().getMethodInvocationHandler(methodIdentifier);
            if (handler == null) {
                throw new IllegalStateException("No invocation handler registered for: " + methodIdentifier);
            }
            if (handler.isWriteMethod()) {
                this._context.getXmlModel().getDomModel().verifyWriteLock();
            } else {
                this._context.getXmlModel().getDomModel().verifyLock();
            }
            return handler.invoke(xmlBaseType, method, args, this._context);
        }
    }
}

