/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.macros.MacroHandler;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ideimpl.macros.MacroHook;
import oracle.ideimpl.macros.MacrosArb;
import oracle.javatools.util.Log;

public class MacroUtils {
    private static final String MACRO_PATTERN = "\\$\\{.+\\}";
    private static Log MACRO_LOG = new Log("MacroUtils");

    public static List<String> getMacroNames(Context context) {
        ArrayList<String> results = new ArrayList<String>();
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        for (MacroHandler handler : MacroHook.getMacroHandlers(workspace, project).values()) {
            for (String macro : handler.getNames(context)) {
                results.add(handler.getQualifier() + ":" + macro);
            }
        }
        return results;
    }

    public static List<String> getMacroExpressions(Context context) {
        ArrayList<String> results = new ArrayList<String>();
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        for (MacroHandler handler : MacroHook.getMacroHandlers(workspace, project).values()) {
            for (String macro : handler.getNames(context)) {
                results.add("${" + handler.getQualifier() + ":" + macro + "}");
            }
        }
        return results;
    }

    public static List<MacroHandler> getMacroHandlers(Context context) {
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        return new ArrayList<MacroHandler>(MacroHook.getMacroHandlers(workspace, project).values());
    }

    public static String getQualifier(String macro) {
        String qualifiedKey = macro.replaceAll("\\$\\{", "").replaceAll("\\}", "");
        int separatorLocation = qualifiedKey.indexOf(58);
        if (separatorLocation == -1) {
            return null;
        }
        String qualifier = qualifiedKey.substring(0, separatorLocation);
        return qualifier;
    }

    public static String getKey(String macro) {
        String qualifiedKey = macro.replaceAll("\\$\\{", "").replaceAll("\\}", "");
        int separatorLocation = qualifiedKey.indexOf(58);
        if (separatorLocation == -1) {
            return null;
        }
        String key = qualifiedKey.substring(separatorLocation + 1);
        return key;
    }

    public static MacroHandler getHandler(Context context, String qualifier) {
        Workspace workspace = context == null ? null : context.getWorkspace();
        Project project = context == null ? null : context.getProject();
        return MacroHook.getMacroHandlers(workspace, project).get(qualifier);
    }

    public static String getDescription(Context context, String macro) {
        String qualifier = MacroUtils.getQualifier(macro);
        if (qualifier == null) {
            return MacrosArb.get("NO_DESCRIPTION_AVAILABLE");
        }
        String key = MacroUtils.getKey(macro);
        MacroHandler handler = MacroUtils.getHandler(context, qualifier);
        if (handler == null) {
            return MacrosArb.get("NO_DESCRIPTION_AVAILABLE");
        }
        return handler.getDescription(context, key);
    }

    public static String getValue(Context context, String macro) {
        String qualifier = MacroUtils.getQualifier(macro);
        if (qualifier == null) {
            return macro;
        }
        String key = MacroUtils.getKey(macro);
        MacroHandler handler = MacroUtils.getHandler(context, qualifier);
        if (handler == null) {
            return macro;
        }
        String value = handler.getValue(context, key);
        if (value == null) {
            return macro;
        }
        if (MacroUtils.isMacroExpression(value)) {
            String original = value;
            value = MacroUtils.expand(context, original);
        }
        return value;
    }

    public static URL getValueAsURL(Context context, String macro) {
        return MacroUtils.getValueAsURL(context, macro, false);
    }

    public static URL getValueAsURL(Context context, String macro, boolean mustBeDirectory) {
        String protocolSeparator;
        String value = MacroUtils.getValue(context, macro);
        if (mustBeDirectory && !value.endsWith(File.separator)) {
            value = value + File.separator;
        }
        URL fileURL = !value.contains(protocolSeparator = ":/") ? URLFactory.newFileURL((String)value) : URLFactory.newURL((String)value);
        return fileURL;
    }

    public static boolean isMacroExpression(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        return MacroUtils.getFirstMacroInExpression(expression) != null;
    }

    public static String getFirstMacroInExpression(String expression) {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Pattern p = Pattern.compile(MACRO_PATTERN);
        Matcher m = p.matcher(expression);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static String expand(Context context, String expression) {
        if (expression == null) {
            return null;
        }
        Pattern p = Pattern.compile(MACRO_PATTERN);
        Matcher m = p.matcher(expression);
        StringBuffer result = new StringBuffer();
        String slash = "\\";
        String dollar = "$";
        String expansion = null;
        while (m.find()) {
            String macro = m.group();
            String qualifier = MacroUtils.getQualifier(macro);
            MacroHandler handler = MacroUtils.getHandler(context, qualifier);
            String key = MacroUtils.getKey(macro);
            if (handler != null && key != null) {
                expansion = handler.getValue(context, key);
            }
            MACRO_LOG.trace("MacroUtils.expand: key " + key + " has expansion " + expansion);
            if (expansion != null && expansion.startsWith("file:")) {
                expansion = expansion.substring(5);
            }
            if (expansion == null) {
                expansion = macro;
            }
            if (expansion != null) {
                MACRO_LOG.trace(" will update expression " + expression + " with expansion " + expansion);
                m.appendReplacement(result, Matcher.quoteReplacement(expansion));
                MACRO_LOG.trace(" intermediate result: " + result);
                continue;
            }
            String escapedMacro = macro.replace(dollar, slash + dollar);
            MACRO_LOG.trace(" no valid expansion, returning " + expression + " with intact macro " + escapedMacro);
            m.appendReplacement(result, escapedMacro);
            MACRO_LOG.trace(" intermediate result: " + result);
        }
        m.appendTail(result);
        MACRO_LOG.trace(" after all macros expanded: " + result);
        int scanFrom = result.indexOf("file:") == 0 ? 7 : 3;
        int offset = result.indexOf("//", scanFrom);
        while (offset != -1) {
            result = result.replace(offset, offset + 2, "/");
            offset = result.indexOf("//", offset);
            MACRO_LOG.trace(" found doubled slash, fixed: " + result);
        }
        String resultString = result.toString();
        MACRO_LOG.trace(" final result: " + resultString);
        resultString = resultString.replace(slash + dollar, dollar);
        return resultString;
    }

    public static URL expandAndMakeURL(Context context, String expression) {
        String expanded = MacroUtils.expand(context, expression);
        URL url = MacroUtils.makeURLFromString(expanded);
        return url;
    }

    public static URL expand(Context context, URL url) {
        String initialUrlAsString = url.toExternalForm();
        String resultUrlAsString = MacroUtils.expand(context, initialUrlAsString);
        URL result = MacroUtils.makeURLFromString(resultUrlAsString);
        if (result == null) {
            return url;
        }
        return result;
    }

    private static URL makeURLFromString(String expression) {
        URL url;
        MACRO_LOG.trace("MacroUtils.makeURLFromString(" + expression + ")");
        if (expression == null) {
            return null;
        }
        String pathExpression = expression = expression.replaceAll("macro:", "");
        String protocol = "file";
        String protocolSeparator = ":/";
        if (expression.indexOf(protocolSeparator) > 3) {
            protocol = expression.substring(0, expression.indexOf(protocolSeparator));
            pathExpression = expression.substring(expression.indexOf(protocolSeparator) + 1);
            MACRO_LOG.trace(" Separated protocol " + protocol + " from path " + pathExpression);
        }
        if (protocol.equals("file")) {
            if (pathExpression.contains(".jar")) {
                url = URLFactory.newFileURL((String)pathExpression.replaceAll(".jar!/", ".jar"));
                url = URLFactory.newJarURL((URL)url, null);
            } else {
                url = URLFactory.newFileURL((String)pathExpression);
                MACRO_LOG.trace(" made new file url " + url.toExternalForm());
            }
        } else if (protocol.equals("jar:file")) {
            url = URLFactory.newFileURL((String)pathExpression.replaceAll(".jar!/", ".jar"));
            url = URLFactory.newJarURL((URL)url, null);
            MACRO_LOG.trace(" made new jar:file url " + (url == null ? "null" : url.toExternalForm()));
        } else {
            url = URLFactory.newURL((String)protocol, (String)pathExpression);
            MACRO_LOG.trace(" made new protocol=" + protocol + " url " + (url == null ? "null" : url.toExternalForm()));
        }
        return url;
    }

    public static URL getMacroExpressionFormOfExpandedURL(URL url, String activeMacroExpression, String activeMacroExpandedValue) {
        String path;
        if (activeMacroExpandedValue == null) {
            return url;
        }
        activeMacroExpandedValue = activeMacroExpandedValue.replaceFirst("file:", "");
        if (File.separatorChar == '\\') {
            activeMacroExpression = activeMacroExpression.replace('\\', '/');
            activeMacroExpandedValue = activeMacroExpandedValue.replace('\\', '/');
        }
        if ((path = url.getPath()).contains(activeMacroExpandedValue)) {
            url = URLFactory.replacePathPart((URL)url, (String)path.replace(activeMacroExpandedValue, activeMacroExpression));
        }
        return url;
    }

    public static class URLWrapper
    extends DefaultElement
    implements Locatable {
        private URL urlWithMacroName;

        public URLWrapper(URL url) {
            this.urlWithMacroName = url;
        }

        public URL getURL() {
            return this.urlWithMacroName;
        }

        public void setURL(URL url) {
            this.urlWithMacroName = url;
        }
    }
}

