/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.docgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OracleXMLDocGenDOM
extends OracleXMLDocGen {
    static final int MAX_CHUNK_SIZE = 32512;
    Document doc = null;
    Node currNode = null;
    Hashtable namespaces = null;
    Node firstElementAppended = null;
    boolean firstElementSeen = false;
    boolean rootSupplied = false;
    Node rootNode = null;
    DocumentFragment docFrag = null;

    public OracleXMLDocGenDOM() {
    }

    public OracleXMLDocGenDOM(Node node) {
        if (node == null) {
            throw new OracleXMLSQLException(this.msg.getMessage0("XSUE-0014"));
        }
        this.rootNode = node;
        this.rootSupplied = true;
    }

    @Override
    public void createNewDocument(boolean bl) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.doc = new XMLDocument();
            this.currNode = this.doc;
        } else if (this.firstElementSeen) {
            Node node = this.firstElementAppended;
            while (node != null) {
                Node node2 = node.getNextSibling();
                this.rootNode.removeChild(node);
                node = node2;
            }
            this.currNode = this.rootNode;
        } else {
            this.doc = this.rootNode.getOwnerDocument();
            this.currNode = this.rootNode;
        }
        if (this.encoding != null) {
            ((XMLDocument)this.doc).setEncoding(this.encoding);
        }
    }

    @Override
    public void createProcessingInstruction(String string, String string2) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.piT = string;
            this.piD = string2;
            this.doc.appendChild(this.doc.createProcessingInstruction(string, string2));
        }
    }

    @Override
    public void setVersion(String string) {
        if (this.docFrag != null) {
            return;
        }
        if (!this.rootSupplied) {
            this.version = string;
            ((XMLDocument)this.doc).setVersion(string);
        }
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string == null || string.length() == 0 ? null : string;
        if (this.doc != null) {
            ((XMLDocument)this.doc).setEncoding(this.encoding);
        }
    }

    @Override
    public Object startNewElement(String string) {
        Element element = this.doc.createElementNS(null, string);
        this.currNode.appendChild(element);
        if (!this.firstElementSeen) {
            this.firstElementSeen = true;
            this.firstElementAppended = element;
        }
        this.currNode = element;
        return null;
    }

    @Override
    public void addTextValue(String string, boolean bl) {
        this.checkLegalXMLChars(string);
        Text text = this.doc.createTextNode(string);
        this.currNode.appendChild(text);
    }

    @Override
    public void addTextValue(Reader reader, boolean bl) throws IOException {
        char[] cArray = new char[32512];
        String string = new String();
        int n = 0;
        while ((n = reader.read(cArray, 0, 32512)) != -1) {
            string = string + new String(cArray, 0, n);
        }
        this.checkLegalXMLChars(string);
        this.addTextValue(string, bl);
    }

    @Override
    public void endElement(Object object) {
        this.endElement(object, false);
    }

    public void endElement(Object object, boolean bl) {
        Object object2;
        if (this.currNode == this.firstElementAppended && this.namespaces != null) {
            object2 = null;
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                this.addAttribute("xmlns:" + (String)object2, (String)this.namespaces.get(object2));
            }
        }
        if (this.currNode instanceof Element && bl) {
            object2 = this.doc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil");
            object2.setValue("true");
            ((Element)this.currNode).setAttributeNode((Attr)object2);
        }
        this.currNode = this.currNode.getParentNode();
    }

    @Override
    public void addAttribute(String string, String string2) {
        this.checkLegalXMLChars(string2);
        Attr attr = this.doc.createAttribute(string);
        attr.setValue(string2);
        ((Element)this.currNode).setAttributeNode(attr);
    }

    @Override
    public void insertXMLFragment(Reader reader) throws IOException, XMLParseException, SAXException {
        FragmentReader fragmentReader = new FragmentReader(reader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setErrorStream((OutputStream)System.err);
        dOMParser.showWarnings(false);
        dOMParser.parse((Reader)fragmentReader);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getDocumentElement();
        node = ((XMLDocument)this.doc).adoptNode(node);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            this.currNode.appendChild(node3);
        }
    }

    @Override
    public void insertXMLFragment(Document document) {
        Node node = document.getFirstChild();
        node = ((XMLDocument)this.doc).adoptNode(node);
        this.currNode.appendChild(node);
    }

    @Override
    public String getXMLDocumentString() {
        if (this.docFrag != null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((XMLDocument)this.doc).print(printWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new OracleXMLSQLException(iOException.getMessage(), "ERROR_TAG");
        }
    }

    @Override
    public Document getXMLDocumentDOM() {
        return this.doc;
    }

    public void print(Writer writer) throws IOException {
        ((XMLDocument)this.doc).print(new PrintWriter(writer));
    }

    @Override
    public boolean applyStylesheet(XSLProcessor xSLProcessor, XSLStylesheet xSLStylesheet) {
        try {
            XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSLStylesheet, (XMLDocument)this.doc);
            this.createNewDocument(true);
            if (!this.rootSupplied) {
                if (this.version != null) {
                    this.setVersion(this.version);
                }
                if (this.piT != null) {
                    this.doc.appendChild(this.doc.createProcessingInstruction(this.piT, this.piD));
                }
            }
            this.currNode.appendChild((Node)xMLDocumentFragment);
            return true;
        }
        catch (XSLException xSLException) {
            throw new OracleXMLSQLException((Exception)((Object)xSLException));
        }
    }

    @Override
    public Object getDocFragment() {
        return this.docFrag;
    }

    @Override
    public void appendDTD(String string) {
    }

    @Override
    public OracleXMLDocGen newDocGenDoc(boolean bl) {
        OracleXMLDocGenDOM oracleXMLDocGenDOM = new OracleXMLDocGenDOM();
        if (this.encoding != null) {
            oracleXMLDocGenDOM.setEncoding(this.encoding);
        }
        if (bl) {
            oracleXMLDocGenDOM.doc = this.doc;
            oracleXMLDocGenDOM.docFrag = this.doc.createDocumentFragment();
            oracleXMLDocGenDOM.currNode = oracleXMLDocGenDOM.docFrag;
        } else {
            oracleXMLDocGenDOM.doc = new XMLDocument();
            oracleXMLDocGenDOM.currNode = oracleXMLDocGenDOM.doc;
        }
        return oracleXMLDocGenDOM;
    }

    @Override
    public void docAppend(OracleXMLDocGen oracleXMLDocGen) {
        if (this.docFrag != null) {
            return;
        }
        this.currNode.appendChild((DocumentFragment)oracleXMLDocGen.getDocFragment());
    }

    @Override
    public String addNamespace(String string, String string2) {
        if (!this.firstElementSeen) {
            return null;
        }
        if (this.namespaces == null) {
            this.namespaces = new Hashtable(4);
        }
        return this.namespaces.put(string, string2);
    }

    @Override
    public boolean supportMetatype(int n) {
        return n == 2;
    }

    private static class FragmentReader
    extends Reader {
        private static final byte STATE_START = 0;
        private static final byte STATE_XMLDECL = 1;
        private static final byte STATE_MIDDLE = 2;
        private static final byte STATE_END = 3;
        private static final byte STATE_EOF = 4;
        private static final char[] startTag = "<A>\n".toCharArray();
        private static final char[] endTag = "</A>".toCharArray();
        private Reader src;
        private byte state;
        private int endLoc;

        public FragmentReader(Reader reader) {
            this.src = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
            this.state = 0;
            this.endLoc = 0;
        }

        @Override
        public void close() throws IOException {
            this.src.close();
            this.src = null;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            switch (this.state) {
                case 0: {
                    if (n2 < startTag.length) {
                        throw new IOException();
                    }
                    int n3 = n;
                    for (int i = 0; i < startTag.length; ++i) {
                        cArray[n3++] = startTag[i];
                    }
                    this.state = 1;
                    return startTag.length;
                }
                case 1: {
                    this.state = (byte)2;
                    char[] cArray2 = new char[6];
                    int n4 = this.src.read(cArray2);
                    if (n4 == -1) {
                        this.state = (byte)3;
                        return 0;
                    }
                    String string = new String(cArray2);
                    if (!string.equals("<?xml ")) {
                        System.arraycopy(cArray2, 0, cArray, n, n4);
                        return n4;
                    }
                    int n5 = -1;
                    while (true) {
                        int n6;
                        if ((n6 = this.src.read()) == -1) {
                            throw new IOException();
                        }
                        if (n5 == 63 && n6 == 62) break;
                        n5 = n6;
                    }
                }
                case 2: {
                    int n7 = this.src.read(cArray, n, n2);
                    if (n7 != -1) {
                        return n7;
                    }
                    this.state = (byte)3;
                }
                case 3: {
                    int n7 = 0;
                    int n4 = n;
                    while (this.endLoc < endTag.length && n4 < cArray.length) {
                        cArray[n4++] = endTag[this.endLoc++];
                        ++n7;
                    }
                    if (this.endLoc >= endTag.length) {
                        this.state = (byte)4;
                    }
                    return n7;
                }
                case 4: {
                    return -1;
                }
            }
            throw new IOException();
        }
    }
}

