/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.sql.dml;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSUMesg;
import oracle.xml.sql.core.OracleXMLConvert;
import oracle.xml.sql.dml.OracleXMLSave;

public class OracleXMLStaticSave {
    private static Connection conn;
    private static Hashtable ctxPool;
    private static int ctxHdlSeq;
    private static MutableInt ctxHdlWrap;
    private static Hashtable updColHash;
    private static XSUMesg msg;

    public static int newContext(String string) throws SQLException {
        if (ctxPool == null) {
            conn = new OracleDriver().defaultConnection();
            conn.setAutoCommit(false);
            ctxPool = new Hashtable(10);
            ctxHdlWrap = new MutableInt();
        }
        SaveCtx saveCtx = new SaveCtx(string);
        OracleXMLStaticSave.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, saveCtx);
        return ctxHdlSeq++;
    }

    public static void closeContext(int n) {
        OracleXMLStaticSave.ctxHdlWrap.value = n;
        SaveCtx saveCtx = (SaveCtx)ctxPool.remove(ctxHdlWrap);
        if (saveCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        saveCtx.close();
    }

    private static SaveCtx getCtx(int n) {
        OracleXMLStaticSave.ctxHdlWrap.value = n;
        SaveCtx saveCtx = (SaveCtx)ctxPool.get(ctxHdlWrap);
        if (saveCtx == null) {
            throw new OracleXMLSQLException(msg.getMessage0("XSUE-0100"));
        }
        return saveCtx;
    }

    public static void setXSLT(int n, String string, String string2) {
        OracleXMLStaticSave.getCtx(n).save.setXSLT(string, string2);
    }

    public static void setXSLT(int n, CLOB cLOB, String string) throws SQLException, IOException {
        Reader reader = null;
        reader = cLOB != null ? cLOB.getCharacterStream() : null;
        OracleXMLStaticSave.getCtx(n).save.setXSLT(reader, string);
        if (reader != null) {
            reader.close();
        }
    }

    public static void setXSLTParam(int n, String string, String string2) {
        OracleXMLStaticSave.getCtx(n).save.setXSLTParam(string, string2);
    }

    public static void removeXSLTParam(int n, String string) {
        OracleXMLStaticSave.getCtx(n).save.removeXSLTParam(string);
    }

    public static void setRowTag(int n, String string) {
        OracleXMLStaticSave.getCtx(n).save.setRowTag(string);
    }

    public static void setPreserveWhitespace(int n, byte by) {
        OracleXMLStaticSave.getCtx(n).save.setPreserveWhitespace(by != 0);
    }

    public static void setSQLToXMLNameEscaping(int n, byte by) {
        OracleXMLStaticSave.getCtx(n).save.setSQLToXMLNameEscaping(by != 0);
    }

    public static void setIgnoreCase(int n, byte by) {
        OracleXMLStaticSave.getCtx(n).save.setIgnoreCase(by != 0);
    }

    public static void setDateFormat(int n, String string) {
        OracleXMLStaticSave.getCtx(n).save.setDateFormat(string);
    }

    public static void setBatchSize(int n, int n2) {
        OracleXMLStaticSave.getCtx(n).save.setBatchSize(n2);
    }

    public static void setCommitBatch(int n, int n2) {
        OracleXMLStaticSave.getCtx(n).save.setCommitBatch(n2);
    }

    public static void setUpdateColumn(int n, String string) {
        OracleXMLStaticSave.getCtx(n).save.setUpdateColumn(string);
    }

    public static void clearUpdateColumnList(int n) {
        OracleXMLStaticSave.getCtx(n).save.clearUpdateColumnList();
    }

    public static void setKeyColumn(int n, String string) {
        OracleXMLStaticSave.getCtx(n).save.setKeyColumn(string);
    }

    public static void clearKeyColumnList(int n) {
        OracleXMLStaticSave.getCtx(n).save.clearKeyColumnList();
    }

    public static int insertXML(int n, String string) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            return saveCtx.save.insertXML(string);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static int insertXML(int n, CLOB cLOB) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            Reader reader = cLOB.getCharacterStream();
            int n2 = saveCtx.save.insertXML(reader);
            reader.close();
            return n2;
        }
        catch (SQLException sQLException) {
            saveCtx.errCode = sQLException.getErrorCode();
            saveCtx.errMsg = sQLException.getMessage();
            throw sQLException;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
        catch (IOException iOException) {
            saveCtx.errCode = -1;
            saveCtx.errMsg = iOException.getMessage();
            throw iOException;
        }
    }

    public static int updateXML(int n, String string) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            return saveCtx.save.updateXML(string);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static int updateXML(int n, CLOB cLOB) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            Reader reader = cLOB.getCharacterStream();
            int n2 = saveCtx.save.updateXML(reader);
            reader.close();
            return n2;
        }
        catch (SQLException sQLException) {
            saveCtx.errCode = sQLException.getErrorCode();
            saveCtx.errMsg = sQLException.getMessage();
            throw sQLException;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
        catch (IOException iOException) {
            saveCtx.errCode = -1;
            saveCtx.errMsg = iOException.getMessage();
            throw iOException;
        }
    }

    public static int deleteXML(int n, String string) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            return saveCtx.save.deleteXML(string);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static int deleteXML(int n, CLOB cLOB) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            Reader reader = cLOB.getCharacterStream();
            int n2 = saveCtx.save.deleteXML(reader);
            reader.close();
            return n2;
        }
        catch (SQLException sQLException) {
            saveCtx.errCode = sQLException.getErrorCode();
            saveCtx.errMsg = sQLException.getMessage();
            throw sQLException;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
        catch (IOException iOException) {
            saveCtx.errCode = -1;
            saveCtx.errMsg = iOException.getMessage();
            throw iOException;
        }
    }

    public static void propagateOriginalException(int n, byte by) {
        OracleXMLStaticSave.getCtx(n).propOriginalExc = by != 0;
    }

    public static void getExceptionContent(int n, int[] nArray, String[] stringArray) {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        nArray[0] = saveCtx.errCode;
        stringArray[0] = saveCtx.errMsg;
    }

    public static void useDBDates(int n, byte by) {
        OracleXMLStaticSave.getCtx(n).save.useDBDates(by != 0);
    }

    public static int insertXML_p(int n, String string) throws Exception {
        SaveCtx saveCtx = OracleXMLStaticSave.getCtx(n);
        try {
            URL uRL = OracleXMLSave.getURL(string);
            return OracleXMLStaticSave.getCtx(n).save.insertXML(uRL);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            saveCtx.errCode = oracleXMLSQLException.getErrorCode();
            saveCtx.errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw saveCtx.propOriginalExc && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static int newContext(Connection connection, String string) throws SQLException {
        if (ctxPool == null) {
            conn = connection;
            conn.setAutoCommit(false);
            ctxPool = new Hashtable(10);
            ctxHdlWrap = new MutableInt();
        }
        SaveCtx saveCtx = new SaveCtx(string);
        OracleXMLStaticSave.ctxHdlWrap.value = ctxHdlSeq;
        ctxPool.put(ctxHdlWrap, saveCtx);
        return ctxHdlSeq++;
    }

    static {
        ctxPool = null;
        ctxHdlSeq = 0;
        ctxHdlWrap = null;
        updColHash = null;
        msg = OracleXMLConvert.msg;
    }

    private static class SaveCtx {
        private OracleXMLSave save = null;
        private boolean propOriginalExc = false;
        private int errCode = 0;
        private String errMsg = null;

        SaveCtx(String string) {
            this.save = new OracleXMLSave(conn, string);
            updColHash = new Hashtable(5);
        }

        private void close() {
            this.save.close();
        }
    }

    private static class MutableInt {
        public int value = 0;

        private MutableInt() {
        }

        public int hashCode() {
            return this.value;
        }
    }
}

