/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.validation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.HCSActionDDLPanel;
import oracle.hcs.validation.HCSValidationDialog;
import oracle.hcs.validation.HCSValidationQuery;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HCSValidationPanel
extends JPanel {
    private HCSValidationDialog hierarchyValidationDialog;
    private String owner;
    private DBObject dbObject;
    private ResultSetTable resultSetTable;
    private OracleDatabaseImpl db;
    private HCSValidationQuery hcsValidationQry;
    private String validationTableName;
    private String resultsTableLabel;
    private long logNumber;
    private Logger Log = Logger.getLogger(HCSValidationPanel.class.getName());

    public HCSValidationPanel(OracleDatabaseImpl oracleDatabaseImpl, String string, DBObject dBObject, String string2, Long l, String string3) {
        this.db = oracleDatabaseImpl;
        this.owner = string;
        this.dbObject = dBObject;
        this.validationTableName = string2;
        this.resultsTableLabel = string3;
        this.logNumber = l;
        this.hcsValidationQry = new HCSValidationQuery(dBObject);
        this.init();
        this.showValidationTableResults();
    }

    protected void setOwningDialog(HCSValidationDialog hCSValidationDialog) {
        this.hierarchyValidationDialog = hCSValidationDialog;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = this.createValidationPanel();
        this.add((Component)jPanel, gridBagConstraints);
        JButton jButton = new JButton(HCSArb.getString("HIERARCHY_VALIDATION_CLOSE_BUTTON"));
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HCSValidationPanel.this.closeTableModel();
                HCSValidationPanel.this.hierarchyValidationDialog.dispose();
            }
        });
    }

    private JPanel createValidationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        JPanel jPanel2 = this.createValidationSQLPanel();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)new JLabel(this.resultsTableLabel), gridBagConstraints);
        this.resultSetTable = new ResultSetTable();
        JScrollPane jScrollPane = new JScrollPane((Component)this.resultSetTable);
        jScrollPane.setName("resultSetTableScrollPane");
        jScrollPane = new JScrollPane((Component)this.resultSetTable);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel createValidationSQLPanel() {
        String string = this.dbObject.getObjectName();
        HCSActionDDLPanel hCSActionDDLPanel = new HCSActionDDLPanel();
        String string2 = this.getValidationResultsQuery(string);
        hCSActionDDLPanel.setDDLText(string2);
        return hCSActionDDLPanel;
    }

    private String getValidationResultsQuery(String string) {
        String string2 = null;
        string2 = String.format(this.hcsValidationQry.getQuery("get_log_details"), this.owner, this.validationTableName, Long.toString(this.logNumber));
        return string2;
    }

    public void showValidationTableResults() {
        String string = this.dbObject.getObjectName();
        try {
            String string2 = this.getValidationResultsQuery(string);
            String string3 = this.db.getQualifiedName();
            this.resultSetTable.setQuery(string3, string2, null, null);
            this.resultSetTable.refresh();
            this.resultSetTable.allRowsFetched();
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, "In method showValidationTableResults, sql error occurred", exception);
        }
    }

    private void closeTableModel() {
        if (this.resultSetTable != null) {
            this.resultSetTable.closeModel();
        }
    }
}

