/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.util.SelectionNode;
import oracle.hcs.util.TreeSelectionRenderer;
import oracle.hcs.util.TreeSelectorFilter;
import oracle.hcs.util.TreeSelectorToolTip;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class TreeSelectorDialog
extends JDialog {
    private TreeTableModel treeModel;
    private JFastTreeTable treeTable;
    private TreeSelectionRenderer treeRenderer;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton helpBtn;
    private List<Object> userSelection;
    private boolean okClicked;
    private TreeSelectorFilter filter;
    private SearchField searchField;
    private TreeSelectorToolTip treeSelectorToolTip;
    private boolean forceSelection;
    private String helpTopicID;
    private final String CANCEL_COMMAND = "CANCEL_ID";

    public TreeSelectorDialog(TreeTableModel treeTableModel, TreeSelectionRenderer treeSelectionRenderer, TreeSelectorFilter treeSelectorFilter, String string) {
        this(treeTableModel, treeSelectionRenderer, treeSelectorFilter, false, string);
    }

    public TreeSelectorDialog(TreeTableModel treeTableModel, TreeSelectionRenderer treeSelectionRenderer, TreeSelectorFilter treeSelectorFilter, boolean bl, String string) {
        super((Frame)Ide.getMainWindow());
        this.setTitle(HCSArb.getString("HIERARCHY_SELECTOR_DIALOG_TITLE"));
        this.treeModel = treeTableModel;
        this.treeRenderer = treeSelectionRenderer;
        this.userSelection = new ArrayList<Object>();
        this.forceSelection = bl;
        this.filter = treeSelectorFilter;
        this.helpTopicID = string;
        this.initComponents();
        this.setLayout(new GridBagLayout());
        this.layoutComponents(0);
        this.registerKeyboardActions();
        this.setMinimumSize(new Dimension(450, 500));
        super.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.setModal(true);
    }

    public void setTreeSelectorToolTip(TreeSelectorToolTip treeSelectorToolTip) {
        this.treeSelectorToolTip = treeSelectorToolTip;
    }

    private void initComponents() {
        List<String> list;
        this.treeTable = new JFastTreeTable(this.treeModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                if (TreeSelectorDialog.this.treeSelectorToolTip != null) {
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    JTree jTree = TreeSelectorDialog.this.treeTable.getTree();
                    TreePath treePath = jTree.getPathForRow(n);
                    SelectionNode selectionNode = (SelectionNode)treePath.getLastPathComponent();
                    if (!selectionNode.isParent()) {
                        string = TreeSelectorDialog.this.treeSelectorToolTip.getToolTipforNode(treePath.getLastPathComponent());
                    }
                }
                return string;
            }
        };
        this.treeTable.setAutoResizeMode(4);
        this.treeTable.setCellSelectionEnabled(false);
        this.treeTable.setRowSelectionAllowed(true);
        final JTree jTree = this.treeTable.getTree();
        this.treeRenderer.setTreeTable((JTable)this.treeTable);
        jTree.setCellRenderer((TreeCellRenderer)((Object)this.treeRenderer));
        jTree.setRowHeight(this.treeTable.getRowHeight());
        jTree.setShowsRootHandles(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.treeTable, this.helpTopicID);
        this.searchField = new SearchField(SearchField.Style.FILTER);
        if (this.filter != null && (list = this.filter.getCategoriesFilter()) != null) {
            for (String string : list) {
                this.searchField.addCategory(new SearchCategory(string));
            }
        }
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                if (TreeSelectorDialog.this.filter != null) {
                    SearchCategory searchCategory = searchEvent.getSearchCategory();
                    String string = "";
                    if (searchCategory != null) {
                        string = searchCategory.getLabel();
                    }
                    TreeSelectorDialog.this.filter.filterChanged(searchEvent.getSearchText(), string);
                    TreeSelectorDialog.this.treeTable.updateUI();
                }
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.okBtn = new JButton(HCSArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectorDialog.this.handleUserSelection();
            }
        });
        this.cancelBtn = new JButton(HCSArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectorDialog.this.setVisible(false);
                TreeSelectorDialog.this.dispose();
            }
        });
        this.helpBtn = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp((JComponent)TreeSelectorDialog.this.treeTable);
            }
        });
        if (this.treeTable.getRowCount() == 0) {
            this.treeTable.setEnabled(false);
        }
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        jTree.setRootVisible(false);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreeSelectorDialog.this.handleUserSelection(jTree, mouseEvent);
            }
        });
    }

    private void handleUserSelection() {
        this.populateUserSelection(this.treeTable.getTree());
    }

    private void populateUserSelection(JTree jTree) {
        if (jTree.getSelectionPaths() != null) {
            for (TreePath treePath : jTree.getSelectionPaths()) {
                SelectionNode selectionNode = (SelectionNode)treePath.getLastPathComponent();
                if (selectionNode.isParent()) continue;
                this.userSelection.add(treePath.getLastPathComponent());
            }
            if (!this.userSelection.isEmpty()) {
                this.okClicked = true;
                this.setVisible(false);
            }
        } else {
            this.noSelectionError();
        }
    }

    protected void noSelectionError() {
    }

    private void handleUserSelection(JTree jTree, MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            if (jTree.getSelectionPaths().length > 1) {
                this.populateUserSelection(jTree);
            } else {
                SelectionNode selectionNode = (SelectionNode)jTree.getSelectionPath().getLastPathComponent();
                if (selectionNode.isParent()) {
                    jTree.expandRow(this.treeTable.getSelectedRow());
                } else {
                    this.populateUserSelection(jTree);
                }
            }
        } else {
            SelectionNode selectionNode = (SelectionNode)jTree.getSelectionPath().getPath()[0];
            if (selectionNode.isParent()) {
                int n = this.treeTable.getSelectedRow();
                if (jTree.isExpanded(n)) {
                    jTree.collapseRow(n);
                } else {
                    jTree.expandRow(n);
                }
            }
        }
    }

    protected void layoutComponents(int n) {
        JLabel jLabel;
        JComponent jComponent;
        if (this.filter != null) {
            jComponent = new JPanel(new GridBagLayout());
            jLabel = new JLabel(this.filter.getName());
            jComponent.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            jComponent.add((Component)this.searchField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)jComponent, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        jComponent = new JScrollPane((Component)this.treeTable);
        this.add((Component)jComponent, new GridBagConstraints(0, n++, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jLabel = new DialogButtonBar();
        jLabel.add(this.helpBtn, DialogButtonBar.CONSTRAINT_HELP);
        jLabel.add(this.okBtn, DialogButtonBar.CONSTRAINT_APPLY);
        if (!this.forceSelection) {
            jLabel.add(this.cancelBtn, DialogButtonBar.CONSTRAINT_CANCEL);
        }
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void setSingleSelectionMode() {
        this.treeTable.setSelectionMode(0);
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectorDialog.this.setVisible(false);
                TreeSelectorDialog.this.dispose();
            }
        };
        if (!this.forceSelection) {
            jRootPane.registerKeyboardAction(actionListener, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        }
    }

    public boolean isOkClicked() {
        return this.okClicked;
    }

    public List<Object> getUserSelection() {
        return this.userSelection;
    }
}

