/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.search.SchemaNode;
import oracle.dbtools.util.Logger;
import oracle.hcs.HCSArb;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Source;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.db.source.Synonym;
import oracle.hcs.db.source.Table;
import oracle.hcs.db.source.View;
import oracle.hcs.db.view.OtherUsersFolder;
import oracle.hcs.db.view.SynonymNode;
import oracle.hcs.db.view.TableNode;
import oracle.hcs.db.view.ViewNode;
import oracle.hcs.util.SelectionTree;
import oracle.hcs.util.SelectionTreeModel;
import oracle.hcs.util.SourceCheckboxTree;
import oracle.hcs.util.SourceObjectTree;
import oracle.hcs.util.TreePicker;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SourceSelectionDialog
extends JDialog
implements SearchListener {
    private List<DatabaseSource> sources;
    private List<DatabaseSource> initialList = null;
    private String objectName;
    private String objectType;
    private String defaultSchema;
    private boolean singleSelection;
    private JTextArea descriptionText;
    private JLabel filterLabel;
    private SearchField searchField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private SourceMetadata sourceMetadata;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private Shuttle shuttle;
    private SourceObjectTree objectTree;
    private SelectionTree selectionTree;
    private TreePicker fromPicker;
    private TreePicker toPicker;
    private String helpTopicID;
    private JPanel panel;
    static final int COL_INCLUDE = 0;
    static final int TABLE_NAME = 1;
    static final int COL_NAME = 2;
    static final int COL_DATATYPE = 3;
    private String GET_TABLE_FROM_SYNONYM = "GET_TABLE_FROM_SYNONYM";

    private SourceSelectionDialog(Window window, SourceMetadata sourceMetadata, String string) {
        this(window, sourceMetadata, string, false, false);
    }

    private SourceSelectionDialog(Window window, SourceMetadata sourceMetadata, String string, boolean bl, boolean bl2) {
        super(window);
        this.sourceMetadata = sourceMetadata;
        this.helpTopicID = string;
        this.singleSelection = bl;
        this.objectTree = bl2 ? new SourceCheckboxTree(null) : new SourceObjectTree(null);
        this.setName("ColumnSelectionDialog");
        this.setModal(true);
        this.setIconImage(HCSImagesArb.getImage("COLUMN_ICON"));
        String string2 = System.getProperty("os.name");
        int n = 700;
        int n2 = 380;
        if (string2.startsWith("Windows")) {
            this.setSize(n + 50, n2 + 50);
            this.setMinimumSize(new Dimension(n + 50, n2 + 50));
        } else {
            this.setSize(n, n2);
            this.setMinimumSize(new Dimension(n, n2));
        }
        this.setLocationRelativeTo(window);
        this.setTitle(HCSArb.getString("COLUMN_SELECTION_DIALOG_TITLE"));
        this.layoutCompoments();
    }

    private void setSingleSelection(boolean bl) {
        this.singleSelection = bl;
    }

    private void setDefaultSchema(String string) {
        this.defaultSchema = string;
    }

    private void setObjectName(String string) {
        this.objectName = string;
    }

    private void setObjectType(String string) {
        this.objectType = string;
    }

    private void init(List<DatabaseSource> list) {
        this.initialList = list;
        this.initializeShuttle();
        this.initSelection(list);
        this.expandSchemaNode();
    }

    public List<String> findMissingSources(List<String> list) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        List<String> list2 = list;
        List<String> list3 = null;
        TreeModel treeModel = this.selectionTree.getModel();
        if (treeModel instanceof SelectionTreeModel) {
            serializable = (SelectionTreeModel)treeModel;
            for (String object4 : list) {
                object3 = new IdentifierElement(object4);
                if (((IdentifierElement)object3).getCount() != 2 || ((String)(object2 = ((IdentifierElement)object3).getFirst())).equals(this.defaultSchema)) continue;
                object = (DefaultMutableTreeNode)((DefaultTreeModel)serializable).getRoot();
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object).children();
                block1: while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!(defaultMutableTreeNode instanceof OtherUsersFolder)) continue;
                    this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
                    Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode.children();
                    while (enumeration2.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration2.nextElement();
                        if (!(defaultMutableTreeNode2 instanceof SchemaNode)) continue;
                        SchemaNode schemaNode = (SchemaNode)defaultMutableTreeNode2;
                        String string = defaultMutableTreeNode2.getUserObject() != null ? defaultMutableTreeNode2.getUserObject().toString() : schemaNode.getLabel();
                        if (!((String)object2).equals(string)) continue;
                        this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                        Enumeration<TreeNode> enumeration3 = defaultMutableTreeNode2.children();
                        while (enumeration3.hasMoreElements()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration3.nextElement();
                            this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
                        }
                        continue block1;
                    }
                }
            }
            list3 = list2 = ((SelectionTreeModel)serializable).findMissingSources(this.defaultSchema, list);
        }
        if ((serializable = (DefaultMutableTreeNode)(treeModel = this.objectTree.getModel()).getRoot()) != null) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)serializable).children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object3 = defaultMutableTreeNode.getUserObject();
                if (!(object3 instanceof DatabaseSource)) continue;
                object2 = (DatabaseSource)object3;
                object = object2.getSchemaName() + "." + object2.getName();
                if (object2.getSchemaName().equals(this.defaultSchema)) {
                    object = object2.getName();
                }
                if (list3.indexOf(object) < 0) continue;
                list3.remove(object);
            }
        }
        return list3;
    }

    private void expandSchemaNode() {
        TreeModel treeModel = this.selectionTree.getModel();
        if (treeModel instanceof SelectionTreeModel) {
            SelectionTreeModel selectionTreeModel = (SelectionTreeModel)treeModel;
            for (DefaultMutableTreeNode defaultMutableTreeNode : selectionTreeModel.getDefaultNodes()) {
                this.selectionTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
    }

    private void layoutCompoments() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceSelectionDialog.this.getSelectedSources() == null || SourceSelectionDialog.this.getSelectedSources().size() < 1) {
                    JOptionPane.showMessageDialog(SourceSelectionDialog.this, HCSArb.getString("SOURCE_SELECTION_DIALOG_WARNING_SELECTION"), HCSArb.getString("SOURCE_SELECTION_DIALOG_WARNING_MESSAGE"), -1);
                    return;
                }
                SourceSelectionDialog.this.sources = SourceSelectionDialog.this.getSelectedSources();
                SourceSelectionDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceSelectionDialog.this.sources = SourceSelectionDialog.this.initialList;
                SourceSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceSelectionDialog.this.showHelp();
            }
        };
        String string = HCSArb.getString("COLUMN_SELECTION_DIALOG_DESC");
        if (this.singleSelection) {
            string = HCSArb.getString("COLUMN_SELECTION_DIALOG_DESC_SINGLE");
        }
        this.descriptionText = new JTextArea(string);
        this.descriptionText.setName("descriptionText");
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(null);
        this.descriptionText.setBorder(null);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)HCSArb.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        this.okButton = new JButton();
        this.okButton.setName("okButton");
        this.cancelButton = new JButton();
        this.cancelButton.setName("cancelButton");
        this.helpButton = new JButton();
        this.helpButton.setName("helpButton");
        this.shuttle = new Shuttle();
        this.shuttle.setName("shuttle");
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.okButton.setAction(this.okAction);
        this.okButton.setText(HCSArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(HCSArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.panel = new JPanel();
        this.panel.setName("panel");
        this.getContentPane().add(this.panel);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 3;
        this.panel.add((Component)this.descriptionText, gridBagConstraints);
        gridBagConstraints.ipady = 120;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.panel.add((Component)this.shuttle, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panel.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)this.searchField, gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, this.helpTopicID);
        this.registerKeyboardActions();
    }

    private List<DatabaseSource> getSelectedSources() {
        return this.objectTree.getList();
    }

    public void addColumns(DatabaseSource databaseSource) {
        try {
            Column[] columnArray = databaseSource.getColumns();
            if (columnArray == null || columnArray != null && columnArray.length == 0) {
                Object object;
                String string = databaseSource.getSchemaName();
                String string2 = databaseSource.getName();
                if (databaseSource instanceof Synonym) {
                    object = new HashMap<String, String>();
                    object.put("OWNER", databaseSource.getSchemaName());
                    object.put("OBJECT", databaseSource.getName());
                    List<List<String>> list = this.sourceMetadata.executeQueryByName(this.GET_TABLE_FROM_SYNONYM, (Map<String, String>)object);
                    for (List<String> list2 : list) {
                        string = list2.get(1);
                        string2 = list2.get(0);
                    }
                }
                object = this.sourceMetadata.getObjectColumns(string, string2);
                databaseSource.setColumns(object.toArray(new Column[object.size()]));
            }
        }
        catch (SQLException sQLException) {
            Logger.severe(SourceSelectionDialog.class, (Throwable)sQLException);
        }
    }

    private void initializeShuttle() {
        this.shuttle.setButtonsShown(5);
        this.initializeFromPicker();
        this.initializeToPicker();
    }

    private void initializeFromPicker() {
        JScrollPane jScrollPane = new JScrollPane();
        this.selectionTree = new SelectionTree(this.sourceMetadata, this.defaultSchema, this.objectName, this.objectType);
        this.selectionTree.setModel(new SelectionTreeModel(new DefaultMutableTreeNode(), new JTextField(), this.sourceMetadata, this.defaultSchema));
        if (this.singleSelection) {
            this.selectionTree.getSelectionModel().setSelectionMode(1);
        }
        jScrollPane.getViewport().add(this.selectionTree);
        this.fromPicker = new TreePicker(this.selectionTree, jScrollPane, this, this.singleSelection);
        this.shuttle.setFromPicker((ItemPicker)this.fromPicker);
        this.shuttle.updateUI();
    }

    private void initializeToPicker() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.objectTree);
        this.toPicker = new TreePicker(this.objectTree, jScrollPane, this);
        this.shuttle.setToPicker((ItemPicker)this.toPicker);
        this.shuttle.updateUI();
    }

    public TreePicker getFromPicker() {
        return this.fromPicker;
    }

    public TreePicker getToPicker() {
        return this.toPicker;
    }

    private List<DefaultMutableTreeNode> buildInitialNodes(List<DatabaseSource> list) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (DatabaseSource databaseSource : list) {
            Source source;
            if (databaseSource instanceof Table) {
                source = new Table(databaseSource.getSchemaName(), databaseSource.getName());
                source.setColumns(databaseSource.getColumns());
                arrayList.add(new TableNode((Table)source));
                continue;
            }
            if (databaseSource instanceof View) {
                source = new View(databaseSource.getSchemaName(), databaseSource.getName());
                source.setColumns(databaseSource.getColumns());
                arrayList.add(new ViewNode((View)source));
                continue;
            }
            if (!(databaseSource instanceof Synonym)) continue;
            source = new Synonym(databaseSource.getSchemaName(), databaseSource.getName());
            source.setColumns(databaseSource.getColumns());
            arrayList.add(new SynonymNode((Synonym)source));
        }
        return arrayList;
    }

    private void initSelection(List<DatabaseSource> list) {
        if (list != null && list.size() > 0) {
            List<DefaultMutableTreeNode> list2 = this.buildInitialNodes(list);
            boolean bl = ((TreePicker)this.shuttle.getToPicker()).addInitialSelection(list2);
            if (bl && this.singleSelection) {
                ((TreePicker)this.shuttle.getFromPicker()).disableMove();
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode : list2) {
                this.selectionTree.addSelectionNode(defaultMutableTreeNode);
            }
        }
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(156, 0), 1);
        jRootPane.registerKeyboardAction(this.okAction, KeyStroke.getKeyStroke(10, 0), 1);
        jRootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void showHelp() {
        HelpSystem.getHelpSystem().showHelp((JComponent)this.panel);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
        this.selectionTree.filter(string);
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    public static List<DatabaseSource> showDialog(Window window, SourceMetadata sourceMetadata, List<DatabaseSource> list, String string, String string2, String string3, String string4) {
        SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog(window, sourceMetadata, string4);
        sourceSelectionDialog.setDefaultSchema(string);
        sourceSelectionDialog.setObjectName(string2);
        sourceSelectionDialog.setObjectType(string3);
        sourceSelectionDialog.init(list);
        sourceSelectionDialog.setVisible(true);
        return sourceSelectionDialog.sources;
    }

    public static List<String> findMissingSources(SourceMetadata sourceMetadata, String string, String string2, String string3, List<String> list, String string4) {
        SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog(null, sourceMetadata, string4);
        sourceSelectionDialog.setDefaultSchema(string);
        sourceSelectionDialog.setObjectName(string2);
        sourceSelectionDialog.setObjectType(string3);
        sourceSelectionDialog.init(null);
        return sourceSelectionDialog.findMissingSources(list);
    }

    public static List<DatabaseSource> showDialog(Window window, SourceMetadata sourceMetadata, List<DatabaseSource> list, String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog(window, sourceMetadata, string4, bl, bl2);
        sourceSelectionDialog.setDefaultSchema(string);
        sourceSelectionDialog.setObjectName(string2);
        sourceSelectionDialog.setObjectType(string3);
        ArrayList<DatabaseSource> arrayList = new ArrayList();
        if (bl && list != null && !list.isEmpty()) {
            arrayList.add(list.get(0));
        } else {
            arrayList = list;
        }
        sourceSelectionDialog.init(arrayList);
        sourceSelectionDialog.setVisible(true);
        return sourceSelectionDialog.sources;
    }

    class DatabaseRenderer
    extends DefaultListCellRenderer {
        private Hashtable iconTable = new Hashtable();

        DatabaseRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Table) {
                Icon icon = HCSImagesArb.getIcon("TABLE_ICON");
                jLabel.setIcon(icon);
            } else if (object instanceof View) {
                Icon icon = HCSImagesArb.getIcon("VIEW_ICON");
                jLabel.setIcon(icon);
            } else if (object instanceof Synonym) {
                Icon icon = HCSImagesArb.getIcon("SYNONYM_ICON");
                jLabel.setIcon(icon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }

    class CWCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border border = new EmptyBorder(1, 2, 1, 2);

        public CWCheckBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Boolean) {
                this.setSelected((Boolean)object);
                this.setEnabled(jTable.isCellEditable(n, n2));
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                }
            } else {
                return null;
            }
            return this;
        }
    }

    class CheckBoxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JCheckBox checkBox = new JCheckBox();

        public CheckBoxCellEditor() {
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.setBackground(Color.white);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            boolean bl2 = false;
            if (object != null) {
                bl2 = (Boolean)object;
            }
            this.checkBox.setSelected(bl2);
            return this.checkBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.isSelected();
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }
}

