/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.controls.search.SchemaNode;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.db.view.FolderNode;
import oracle.hcs.db.view.OtherUsersFolder;
import oracle.hcs.db.view.SynonymFolderNode;
import oracle.hcs.db.view.SynonymNode;
import oracle.hcs.db.view.TableFolderNode;
import oracle.hcs.db.view.TableNode;
import oracle.hcs.db.view.ViewFolderNode;
import oracle.hcs.db.view.ViewNode;
import oracle.hcs.tree.view.JTree2;
import oracle.hcs.util.DatabaseObjectRenderer;

public class SelectionTree
extends JTree2
implements TreeWillExpandListener {
    SourceMetadata sourceMetadata;
    String owner;
    String object;
    String type;
    private final String TABLE = "TABLE";
    private final String VIEW = "VIEW";
    private final String SYNONYM = "SYNONYM";
    private List<String> filters;
    private List<DefaultMutableTreeNode> selectedNodes;
    private Map<String, List<DefaultMutableTreeNode>> tableNodesCache;
    private Map<String, List<DefaultMutableTreeNode>> viewNodesCache;
    private Map<String, List<DefaultMutableTreeNode>> synonymNodesCache;
    private final String GET_OBJECTS_BY_TYPE_QUERY_NAME = "GET_OBJECTS_BY_TYPE";
    private final String GET_OTHER_USERS_SYNONYMS_QUERY_NAME = "GET_OTHER_USERS_SYNONYMS";
    private final String GET_OTHER_USERS_OBJECTS_QUERY_NAME = "GET_OTHER_USERS_OBJECTS";
    private final String TYPE_BIND = "TYPE";
    private final String GRANTEE_BIND = "GRANTEE";
    private final String OWNER_BIND = "OWNER";

    public SelectionTree(SourceMetadata sourceMetadata, String string, String string2, String string3) {
        this.sourceMetadata = sourceMetadata;
        this.owner = string;
        this.object = string2;
        this.type = string3;
        this.filters = new ArrayList<String>();
        this.selectedNodes = new ArrayList<DefaultMutableTreeNode>();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new DatabaseObjectRenderer());
        this.addTreeWillExpandListener(this);
        this.tableNodesCache = new HashMap<String, List<DefaultMutableTreeNode>>();
        this.viewNodesCache = new HashMap<String, List<DefaultMutableTreeNode>>();
        this.synonymNodesCache = new HashMap<String, List<DefaultMutableTreeNode>>();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        FolderNode folderNode;
        if (treeExpansionEvent.getPath().getLastPathComponent() instanceof FolderNode && (folderNode = (FolderNode)treeExpansionEvent.getPath().getLastPathComponent()).getNodes() == null) {
            String string = "GET_OBJECTS_BY_TYPE";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.setSearchType(hashMap, folderNode);
            if (this.isOtherUsersFolder(folderNode)) {
                hashMap.put("GRANTEE", this.owner);
                String string2 = (String)hashMap.get("TYPE");
                if (string2.equals("SYNONYM")) {
                    string = "GET_OTHER_USERS_SYNONYMS";
                    hashMap.remove("TYPE");
                } else {
                    string = "GET_OTHER_USERS_OBJECTS";
                }
            }
            this.loadChildren(folderNode, string, hashMap);
        }
    }

    private void loadChildren(FolderNode folderNode, String string, Map<String, String> map) {
        if (folderNode != null) {
            List<List<String>> list = this.sourceMetadata.executeQueryByName(string, map);
            LinkedList<List<String>> linkedList = new LinkedList<List<String>>();
            List<String> list2 = this.getViews();
            boolean bl = false;
            for (List<String> list3 : list) {
                String string2 = list3.get(0);
                if (list2.indexOf(string2) != -1) continue;
                linkedList.add(list3);
            }
            folderNode.createChildNodes(linkedList);
            this.update(folderNode);
        }
    }

    private boolean isOtherUsersFolder(FolderNode folderNode) {
        SchemaNode schemaNode;
        return folderNode.getParent() instanceof SchemaNode && (schemaNode = (SchemaNode)folderNode.getParent()).getParent() instanceof OtherUsersFolder;
    }

    private List<String> getViews() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.owner == null || this.object == null || this.type == null) {
            return arrayList;
        }
        arrayList.add(this.object);
        return arrayList;
    }

    private void setSearchType(Map<String, String> map, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = null;
        if (defaultMutableTreeNode instanceof TableFolderNode) {
            string = "TABLE";
        } else if (defaultMutableTreeNode instanceof ViewFolderNode) {
            string = "VIEW";
        } else if (defaultMutableTreeNode instanceof SynonymFolderNode) {
            string = "SYNONYM";
        }
        map.put("OWNER", defaultMutableTreeNode.getParent() != null ? defaultMutableTreeNode.getParent().toString() : "");
        map.put("TYPE", string);
    }

    private void update(FolderNode folderNode) {
        for (DefaultMutableTreeNode defaultMutableTreeNode : folderNode.getNodes()) {
            if (this.selectedNodes.contains(defaultMutableTreeNode)) continue;
            if (this.filters.size() > 0) {
                if (!this.passFilter(defaultMutableTreeNode)) continue;
                folderNode.add(defaultMutableTreeNode);
                continue;
            }
            folderNode.add(defaultMutableTreeNode);
        }
        this.cacheSourceNodes(folderNode);
    }

    private void cacheSourceNodes(FolderNode folderNode) {
        String string = this.getParentSchemaName(folderNode);
        if (folderNode.getNodes().size() > 0) {
            if (folderNode.getNodes().get(0) instanceof TableNode) {
                if (!this.tableNodesCache.containsKey(string)) {
                    List<Object> list = new ArrayList();
                    list = folderNode.getNodes();
                    this.tableNodesCache.put(string, list);
                }
            } else if (folderNode.getNodes().get(0) instanceof ViewNode) {
                if (!this.viewNodesCache.containsKey(string)) {
                    List<Object> list = new ArrayList();
                    list = folderNode.getNodes();
                    this.viewNodesCache.put(string, list);
                }
            } else if (folderNode.getNodes().get(0) instanceof SynonymNode && !this.synonymNodesCache.containsKey(string)) {
                List<Object> list = new ArrayList();
                list = folderNode.getNodes();
                this.synonymNodesCache.put(string, list);
            }
        }
    }

    private String getParentSchemaName(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = "";
        if (defaultMutableTreeNode.getParent() != null) {
            if (defaultMutableTreeNode.getParent() instanceof SchemaNode) {
                SchemaNode schemaNode = (SchemaNode)defaultMutableTreeNode.getParent();
                string = schemaNode.getLabel();
            } else if (defaultMutableTreeNode.getParent() instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                string = (String)defaultMutableTreeNode2.getUserObject();
            }
        }
        return string;
    }

    private boolean passFilter(DefaultMutableTreeNode defaultMutableTreeNode) {
        DatabaseSource databaseSource = (DatabaseSource)defaultMutableTreeNode.getUserObject();
        String string = databaseSource.getName().toUpperCase();
        for (String string2 : this.filters) {
            if (!((string2 = string2.trim().toUpperCase()).endsWith("%") ? string.startsWith(string2.substring(0, string2.length() - 1)) : (string2.startsWith("%") ? string.endsWith(string2.substring(1)) : string.contains(string2)))) continue;
            return true;
        }
        return false;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (!this.isNodeChild(defaultMutableTreeNode) && (defaultMutableTreeNode2 = this.findOwnerNode(defaultMutableTreeNode, treeNode = (TreeNode)this.getModel().getRoot())) != null) {
            this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2);
        }
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        block3: {
            block5: {
                block4: {
                    if (!(defaultMutableTreeNode instanceof TableNode)) break block4;
                    defaultMutableTreeNode.setAllowsChildren(false);
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                        if (!(defaultMutableTreeNode2 instanceof TableFolderNode)) continue;
                        String string = this.getParentSchemaName(defaultMutableTreeNode2);
                        List<DefaultMutableTreeNode> list = this.tableNodesCache.get(string);
                        int n = this.getSourceNodeOrder(defaultMutableTreeNode, list);
                        defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
                        break block3;
                    }
                    break block3;
                }
                if (!(defaultMutableTreeNode instanceof ViewNode)) break block5;
                defaultMutableTreeNode.setAllowsChildren(false);
                for (int i = 0; i < treeNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                    if (!(defaultMutableTreeNode3 instanceof ViewFolderNode)) continue;
                    String string = this.getParentSchemaName(defaultMutableTreeNode3);
                    List<DefaultMutableTreeNode> list = this.viewNodesCache.get(string);
                    int n = this.getSourceNodeOrder(defaultMutableTreeNode, list);
                    defaultMutableTreeNode3.insert(defaultMutableTreeNode, n);
                    break block3;
                }
                break block3;
            }
            if (!(defaultMutableTreeNode instanceof SynonymNode)) break block3;
            defaultMutableTreeNode.setAllowsChildren(false);
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                if (!(defaultMutableTreeNode4 instanceof SynonymFolderNode)) continue;
                String string = this.getParentSchemaName(defaultMutableTreeNode4);
                List<DefaultMutableTreeNode> list = this.synonymNodesCache.get(string);
                int n = this.getSourceNodeOrder(defaultMutableTreeNode, list);
                defaultMutableTreeNode4.insert(defaultMutableTreeNode, n);
                break;
            }
        }
    }

    private int getSourceNodeOrder(DefaultMutableTreeNode defaultMutableTreeNode, List<DefaultMutableTreeNode> list) {
        int n = 0;
        if (list != null && list.size() > 0 && (n = list.indexOf(defaultMutableTreeNode)) == -1) {
            n = 0;
        }
        return n;
    }

    private boolean isNodeChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            if (defaultMutableTreeNode2 != null) {
                for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                    if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public DefaultMutableTreeNode findOwnerNode(DefaultMutableTreeNode defaultMutableTreeNode, TreeNode treeNode) {
        DatabaseSource databaseSource = (DatabaseSource)defaultMutableTreeNode.getUserObject();
        TreeNode treeNode2 = treeNode.getChildAt(0);
        if (treeNode2.toString().equalsIgnoreCase(databaseSource.getSchemaName())) {
            return (DefaultMutableTreeNode)treeNode2;
        }
        TreeNode treeNode3 = treeNode.getChildAt(1);
        for (int i = 0; i < treeNode3.getChildCount(); ++i) {
            TreeNode treeNode4 = treeNode3.getChildAt(i);
            if (!treeNode4.toString().equalsIgnoreCase(databaseSource.getSchemaName())) continue;
            return (DefaultMutableTreeNode)treeNode4;
        }
        return null;
    }

    private boolean isFolderNode(Object object) {
        return object instanceof FolderNode;
    }

    public void filter(String string) {
        this.filters = Arrays.asList(string.split(","));
        Object object = this.getModel().getRoot();
        this.walk(this.getModel(), object);
    }

    protected void walk(TreeModel treeModel, Object object) {
        boolean bl = false;
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (this.isFolderNode(object2)) {
                FolderNode folderNode = (FolderNode)object2;
                folderNode.removeAllChildren();
                if (folderNode.getNodes() == null) continue;
                bl = false;
                for (DefaultMutableTreeNode defaultMutableTreeNode : folderNode.getNodes()) {
                    if (!this.passFilter(defaultMutableTreeNode) || this.selectedNodes.contains(defaultMutableTreeNode)) continue;
                    folderNode.add(defaultMutableTreeNode);
                    bl = true;
                }
                if (bl) {
                    ((DefaultTreeModel)treeModel).reload(folderNode);
                }
                if (this.isExpanded(new TreePath(folderNode.getPath())) && folderNode.getChildCount() == 0) {
                    this.collapsePath(new TreePath(folderNode.getPath()));
                    continue;
                }
                if (!this.isCollapsed(new TreePath(folderNode.getPath())) || folderNode.getChildCount() <= 0) continue;
                this.expandPath(new TreePath(folderNode.getPath()));
                continue;
            }
            this.walk(treeModel, object2);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void addSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!this.selectedNodes.contains(defaultMutableTreeNode)) {
            this.selectedNodes.add(defaultMutableTreeNode);
        }
    }

    public boolean removeSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        return this.selectedNodes.remove(defaultMutableTreeNode);
    }
}

