/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import oracle.hcs.util.HyperLabelActionListener;
import oracle.hcs.util.HyperParamActionListener;
import oracle.hcs.util.HyperParamColoringHelper;

public class HyperLabel
extends JLabel
implements HyperParamColoringHelper,
HyperParamActionListener {
    private HyperFocusListener hfl;
    private MouseListener ml;
    private List<HyperLabelActionListener> hyperLabelActionListeners;
    private Object context;
    private boolean m_blnIsEnabled = true;
    private Color m_focusForeColor = UIManager.getColor("ComboBox.selectionForeground");
    private Color m_focusBackColor = UIManager.getColor("ComboBox.selectionBackground");
    private Color m_hyperForeColor = Color.blue;
    private Color m_lblBackColor1 = UIManager.getColor("Panel.background");
    private Color m_lblBackColor2 = UIManager.getColor("ComboBox.background");

    public HyperLabel(String string) {
        this(null, string);
    }

    public HyperLabel(final Object object, String string) {
        super(string);
        this.context = object;
        this.setOpaque(true);
        this.setBorder(null);
        this.setDoubleBuffered(true);
        this.setEnabled(true);
        this.setRequestFocusEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.hyperLabelActionListeners = new ArrayList<HyperLabelActionListener>();
        this.hfl = new HyperFocusListener();
        this.addFocusListener(this.hfl);
        this.ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (HyperLabel.this.hyperLabelActionListeners != null) {
                    for (HyperLabelActionListener hyperLabelActionListener : HyperLabel.this.hyperLabelActionListeners) {
                        hyperLabelActionListener.actionPerformed(object, HyperLabel.this.getText());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.addMouseListener(this.ml);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HyperLabel.this.hyperLabelActionListeners != null) {
                    for (HyperLabelActionListener hyperLabelActionListener : HyperLabel.this.hyperLabelActionListeners) {
                        hyperLabelActionListener.actionPerformed(object, HyperLabel.this.getText());
                    }
                }
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (HyperLabelActionListener hyperLabelActionListener : HyperLabel.this.hyperLabelActionListeners) {
                    hyperLabelActionListener.forwardDownKeyPress();
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 1);
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 8), 1);
        this.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(40, 0), 1);
    }

    @Override
    public void actionPerformed() {
        if (this.hyperLabelActionListeners != null) {
            for (HyperLabelActionListener hyperLabelActionListener : this.hyperLabelActionListeners) {
                hyperLabelActionListener.actionPerformed(this.context, this.getText());
            }
        }
    }

    public void addActionListener(HyperLabelActionListener hyperLabelActionListener) {
        this.hyperLabelActionListeners.add(hyperLabelActionListener);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = this.m_hyperForeColor;
        Color color2 = this.m_lblBackColor1 != null ? this.m_lblBackColor1 : this.m_lblBackColor2;
        Color color3 = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setFont(this.getFont());
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.getText();
        if (this.m_blnIsEnabled) {
            if (this.hasFocus()) {
                color = this.m_focusForeColor;
                color2 = this.m_focusBackColor;
            }
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            int n3 = n / 2 - fontMetrics.stringWidth(string) / 2;
            int n4 = fontMetrics.getAscent();
            graphics.drawString(string, n3, n4);
            graphics.drawLine(n3, n4 + 1, n - n3, n4 + 1);
            graphics.setColor(color3);
            graphics.setFont(font);
        } else {
            super.paint(graphics);
        }
    }

    public void paintOld(Graphics graphics) {
        super.paint(graphics);
        Color color = this.getForeground();
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), graphics);
        int n = this.getHeight() / 2 + (int)(rectangle2D.getHeight() / 2.0);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        graphics.setColor(color);
        graphics.drawLine(0, n, n3 + n2, n);
    }

    public void cleanup() {
        this.removeFocusListener(this.hfl);
        this.removeMouseListener(this.ml);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.ml = null;
        this.hfl = null;
        this.hyperLabelActionListeners = null;
        this.context = null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.m_lblBackColor1 = color;
    }

    private class HyperMouseInputListener
    extends MouseInputAdapter {
        private HyperMouseInputListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (HyperLabel.this.m_blnIsEnabled) {
                HyperLabel.this.requestFocusInWindow();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (HyperLabel.this.m_blnIsEnabled) {
                HyperLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                HyperLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HyperLabel.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class HyperFocusListener
    implements FocusListener {
        private HyperFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            HyperLabel.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            HyperLabel.this.repaint();
        }
    }
}

