/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.hcs.HCSArb;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.util.Resources;

public class HCSResources
implements Resources {
    private Map<String, XLIFFHelper> xliffResources = new HashMap<String, XLIFFHelper>();

    public HCSResources() {
        this("");
    }

    public HCSResources(String string) {
        if (string != null && string.lastIndexOf("/") > -1) {
            String string2 = string.substring(string.lastIndexOf("/") + 1);
            this.addXLIFFTranslationResource(string2, string);
        }
    }

    @Override
    public String getString(String string) {
        String string2 = HCSArb.get(string);
        if (string2.length() > 1 && string2.substring(1, string2.length() - 1).equals(string)) {
            string2 = HCSNavigatorResource.get(string);
        }
        return string2;
    }

    @Override
    public String getString(String string, String string2) {
        return HCSArb.format(string, string2);
    }

    @Override
    public String getString(String string, String string2, String string3) {
        return HCSArb.format(string, string2, string3);
    }

    @Override
    public String getString(String string, String[] stringArray) {
        return HCSArb.format(string, stringArray);
    }

    @Override
    public String getXLIFFResource(String string, String string2) {
        XLIFFHelper xLIFFHelper;
        if (string != null && !string.isEmpty() && (xLIFFHelper = this.xliffResources.get(string)) != null) {
            return xLIFFHelper.getTranslation(string2);
        }
        return string2;
    }

    @Override
    public void addXLIFFTranslationResource(String string, String string2) {
        if (!this.xliffResources.containsKey(string)) {
            this.xliffResources.put(string, new XLIFFHelper(HCSArb.class.getClassLoader(), string2));
        }
    }

    @Override
    public XLIFFHelper getXLIFFHelper(String string) {
        Iterator<String> iterator;
        XLIFFHelper xLIFFHelper = this.xliffResources.get(string);
        if (xLIFFHelper == null && (iterator = this.xliffResources.keySet().iterator()).hasNext()) {
            String string2 = iterator.next();
            return this.xliffResources.get(string2);
        }
        return xLIFFHelper;
    }
}

