/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;

public class HCSObjectsTimestamps {
    private static final String DATE_FORMAT = "yyyy-MM-dd:HH:mm:ss";
    private static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
    private static final String ATTRIBUTE_DIMENSION = "ATTRIBUTE DIMENSION";
    private static final String HIERARCHY = "HIERARCHY";
    private static final String ANALYTIC_VIEW = "ANALYTIC VIEW";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static HCSSchema getLatestHCSObjectsTimestamps(Connection connection, String string) {
        HCSSchema hCSSchema;
        block11: {
            hCSSchema = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", string);
            String string2 = "select object_name, object_type, timestamp from all_objects where owner = :owner and object_type in ('ATTRIBUTE DIMENSION','HIERARCHY','ANALYTIC VIEW')";
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            ResultSet resultSet = null;
            try {
                Connections.getInstance().lock(connection);
                resultSet = dBUtil.executeQuery(string2, hashMap);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
                if (resultSet != null) {
                    hCSSchema = new HCSSchema(string);
                    while (resultSet.next()) {
                        AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc;
                        String string3 = resultSet.getString(2);
                        String string4 = resultSet.getString(1);
                        String string5 = resultSet.getString(3);
                        if (string3.equalsIgnoreCase(ATTRIBUTE_DIMENSION)) {
                            abstractMappableSchemaObjectWithDesc = new AttributeDimension();
                            HCSObjectsTimestamps.setObjectNameAndTimestamp(abstractMappableSchemaObjectWithDesc, string4, string5);
                            hCSSchema.addDimension((AttributeDimension)abstractMappableSchemaObjectWithDesc);
                            continue;
                        }
                        if (string3.equalsIgnoreCase(HIERARCHY)) {
                            abstractMappableSchemaObjectWithDesc = new Hierarchy();
                            HCSObjectsTimestamps.setObjectNameAndTimestamp(abstractMappableSchemaObjectWithDesc, string4, string5);
                            hCSSchema.addHierarchy((Hierarchy)abstractMappableSchemaObjectWithDesc);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase(ANALYTIC_VIEW)) continue;
                        abstractMappableSchemaObjectWithDesc = new AnalyticView();
                        HCSObjectsTimestamps.setObjectNameAndTimestamp(abstractMappableSchemaObjectWithDesc, string4, string5);
                        hCSSchema.addAV((AnalyticView)abstractMappableSchemaObjectWithDesc);
                    }
                }
                if (resultSet == null) break block11;
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    DBUtil.closeResultSet(resultSet);
                }
                Connections.getInstance().unlock(connection);
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        DBUtil.closeResultSet(resultSet);
                    }
                    Connections.getInstance().unlock(connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        Connections.getInstance().unlock(connection);
        return hCSSchema;
    }

    private static void setObjectNameAndTimestamp(AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc, String string, String string2) {
        abstractMappableSchemaObjectWithDesc.setName(string);
        abstractMappableSchemaObjectWithDesc.setTimestamp(HCSObjectsTimestamps.getTimestamp(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampForHCSObject(Connection connection, String string, String string2, String string3) {
        long l;
        block8: {
            String string4 = null;
            l = 0L;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", string2);
            hashMap.put("object_name", string3);
            hashMap.put("object_type", string);
            String string5 = "select timestamp from all_objects where owner = :owner and object_name = :object_name and object_type = :object_type";
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            ResultSet resultSet = null;
            try {
                Connections.getInstance().lock(connection);
                resultSet = dBUtil.executeQuery(string5, hashMap);
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
                if (resultSet != null) {
                    while (resultSet.next()) {
                        string4 = resultSet.getString(1);
                        l = HCSObjectsTimestamps.getTimestamp(string4);
                    }
                }
                if (resultSet == null) break block8;
            }
            catch (Exception exception) {
                block9: {
                    try {
                        Logger.getLogger(HCSObjectsTimestamps.class.getName()).severe(exception.getMessage());
                        if (resultSet == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            DBUtil.closeResultSet(resultSet);
                        }
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                Connections.getInstance().unlock(connection);
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        Connections.getInstance().unlock(connection);
        return l;
    }

    public static long getTimestamp(String string) {
        long l = 0L;
        try {
            Date date = dateFormatter.parse(string);
            l = date.getTime();
        }
        catch (Exception exception) {
            Logger.getLogger(HCSObjectsTimestamps.class.getName()).severe(exception.getMessage());
        }
        return l;
    }
}

