/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = CheckBoxList.this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(n)).isSelected());
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = CheckBoxList.this.getSelectedIndex();
                if ((keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) && n != -1) {
                    JCheckBox jCheckBox;
                    jCheckBox.setSelected(!(jCheckBox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(n)).isSelected());
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(300, 300);
        jFrame.setLocation(300, 300);
        CheckBoxList checkBoxList = new CheckBoxList();
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(checkBoxList);
        DefaultComboBoxModel<JCheckBox> defaultComboBoxModel = new DefaultComboBoxModel<JCheckBox>();
        defaultComboBoxModel.addElement(new JCheckBox("First"));
        defaultComboBoxModel.addElement(new JCheckBox("Second"));
        checkBoxList.setModel(defaultComboBoxModel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    protected class CellRenderer
    implements ListCellRenderer {
        protected CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JCheckBox jCheckBox = (JCheckBox)object;
            jCheckBox.setBackground(bl ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            jCheckBox.setForeground(bl ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
            jCheckBox.setEnabled(CheckBoxList.this.isEnabled());
            jCheckBox.setFont(CheckBoxList.this.getFont());
            jCheckBox.setFocusPainted(false);
            jCheckBox.setBorderPainted(true);
            jCheckBox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return jCheckBox;
        }
    }
}

