/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.util.HyperLinkField;

public class TemplateHyperParamNumber
extends TemplateHyperParam {
    private HyperLinkField hyperLinkField;
    private NumberTextField tf;
    private static final String DEFAULT_VALUE = "1";
    private ParseNode pattern;

    public TemplateHyperParamNumber() {
        int n = 1;
        this.tf = new NumberTextField((Number)n, 4);
        this.tf.setText(DEFAULT_VALUE);
        this.hyperLinkField = new HyperLinkField((JTextField)this.tf);
        this.hyperLinkField.addFieldFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TemplateHyperParamNumber.this.changed(TemplateHyperParamNumber.this.tf.getText());
            }
        });
    }

    private void changed(String string) {
        if (string != null && string.length() > 0) {
            Object var2_2 = null;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", var2_2, string);
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    public void setNumber(int n) {
        this.tf.setText(Integer.toString(n));
    }

    @Override
    public Component getComponent() {
        return this.hyperLinkField;
    }

    @Override
    public String getExpression() {
        String string = this.tf.getText();
        if (string.length() > 0) {
            return string;
        }
        return DEFAULT_VALUE;
    }

    @Override
    public Object getValue() {
        return this.getExpression();
    }

    @Override
    public boolean setValue(Object object) {
        if (object != null) {
            if (object instanceof ParseNode) {
                ParseNode parseNode = (ParseNode)object;
                this.hyperLinkField.setText(String.valueOf(parseNode.getValue()));
            } else {
                this.hyperLinkField.setText(String.valueOf(object));
            }
        }
        return true;
    }

    @Override
    public String getDefault() {
        return DEFAULT_VALUE;
    }

    @Override
    public ParseNode getPattern() {
        if (this.pattern == null) {
            this.pattern = new ParseNode(this.getName(), HCSSyntaxType.NUMBER.toString(), ParseNode.PatternType.NONE);
        }
        return this.pattern;
    }

    @Override
    public int getPixelSize(int n) {
        return this.hyperLinkField.getFontMetrics(this.hyperLinkField.getFont()).stringWidth(this.getExpression());
    }
}

