/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.db.LanguageDBSettings;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.hcs.templates.templateview.TemplateSelections;
import oracle.i18n.util.OraLocaleInfo;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class TemplateHyperParamLanguage
extends TemplateHyperParamMultiSelect {
    private static final ParseNode pattern = new ParseNode("language", HCSSyntaxType.STRING.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamLanguage() {
        this.multiSelectEditor = new LanguageSelectionPanel();
        this.editorTitle = HCSArb.getString("HCS_LANGUAGE_TEMPLATE_LANGUAGE_SELECTOR_TITLE");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void init() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getBaseTemplateHyperView().getTemplateContext().getProvider();
            String string = LanguageDBSettings.getDefaultLanguage(oracleDatabaseImpl.getConnection());
            arrayList.add(string);
        }
        catch (DBException dBException) {
            arrayList.add(HCSArb.getString("HCS_LANGUAGE_TEMPLATE_DEFAULT_VALUE"));
            Logger.getLogger(TemplateHyperParamLanguage.class.getName()).log(Level.SEVERE, dBException.getMessage());
        }
        this.setValue(arrayList);
    }

    @Override
    protected void showPicker() {
        this.multiSelectEditor.setSelectedItems(this.selections);
        boolean bl = false;
        bl = UIUtils.showPanelAsDialog((JPanel)((JPanel)((Object)this.multiSelectEditor)), (String)this.editorTitle, null, (int)7);
        if (bl) {
            List<String> list = this.multiSelectEditor.getSelectedItems();
            this.setValue(list);
        }
    }

    private class LanguageSelectionPanel
    extends JPanel
    implements TemplateSelections {
        private JList languagesList;
        private String[] allLanguages = this.initLanguagesList();
        private SearchField searchField;

        public LanguageSelectionPanel() {
            this.languagesList = new JList<String>(this.allLanguages);
            this.languagesList.setSelectionMode(0);
            this.searchField = new SearchField(SearchField.Style.FILTER);
            this.searchField.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent searchEvent) {
                    String string = searchEvent.getSearchText();
                    if (string != null && !string.isEmpty()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (String string2 : LanguageSelectionPanel.this.allLanguages) {
                            if (!string2.toUpperCase().startsWith(string.toUpperCase())) continue;
                            arrayList.add(string2);
                        }
                        LanguageSelectionPanel.this.languagesList.setListData(arrayList.toArray(new String[arrayList.size()]));
                    } else {
                        LanguageSelectionPanel.this.languagesList.setListData(LanguageSelectionPanel.this.allLanguages);
                    }
                }

                public void searchCategoryChanged(SearchEvent searchEvent) {
                }
            });
            this.layoutComponents();
        }

        private String[] initLanguagesList() {
            return OraLocaleInfo.getAvailableLanguages();
        }

        private void layoutComponents() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)new JScrollPane(this.languagesList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 5, 5), 0, 0));
        }

        @Override
        public List<String> getSelectedItems() {
            if (this.languagesList.getSelectedIndex() >= 0) {
                TemplateHyperParamLanguage.this.selections.clear();
                TemplateHyperParamLanguage.this.selections.add((String)this.languagesList.getSelectedValue());
                return TemplateHyperParamLanguage.this.selections;
            }
            return Collections.emptyList();
        }

        @Override
        public void setSelectedItems(List<String> list) {
            String string = list.get(0);
            this.languagesList.setSelectedValue(string, true);
        }
    }
}

