/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;
import oracle.hcs.templates.templateview.TemplateHyperParamHierarchy;
import oracle.javatools.db.AbstractChildDBObject;

public class TemplateHyperParamHierarchyLevel
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyLevel.class.getName());
    private boolean valid;
    private static final String ALL = "ALL";
    public static final String LEVEL_PROPERTY = "level";
    public static final String DIMENSION_PROPERTY = "dimension";
    private static final ParseNode pattern = new ParseNode("hierarchy_level", HCSSyntaxType.LEVEL.toString(), ParseNode.PatternType.NONE);

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public TemplateHyperParamHierarchyLevel() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamHierarchyLevel.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    protected String uiValue(Object object) {
        if (object != null) {
            if (object instanceof HierarchyLevel) {
                HierarchyLevel hierarchyLevel = (HierarchyLevel)object;
                String string = hierarchyLevel.getLevelName();
                return this.getObjectExternalName(string);
            }
            if (object instanceof String) {
                return String.valueOf(object);
            }
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getSelectedElement() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getSelectedElement()));
        }
        return 100;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof Hierarchy) {
            HierarchyLevel hierarchyLevel;
            Hierarchy hierarchy;
            Hierarchy hierarchy2 = (Hierarchy)propertyChangeEvent.getNewValue();
            if (this.getSelectedElement() != null && !hierarchy2.equals(hierarchy = (hierarchyLevel = (HierarchyLevel)this.getSelectedElement()).getHierarchy())) {
                String string = null;
                if (hierarchy != null) {
                    string = hierarchy.getName();
                }
            }
            this.setHierarchy(hierarchy2);
        } else if (propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            AVHierarchy aVHierarchy = (AVHierarchy)propertyChangeEvent.getNewValue();
            if (this.getSelectedElement() != null) {
                AnalyticView analyticView = this.getTemplateContext().getAV();
                HierarchyLevel hierarchyLevel = (HierarchyLevel)this.getSelectedElement();
                Hierarchy hierarchy = hierarchyLevel.getHierarchy();
                String string = hierarchy.getDimensionName();
                String string2 = hierarchy.getName();
                AVHierarchy aVHierarchy2 = analyticView.findDimensionality(string).findHierarchy(string2);
                if (!aVHierarchy.equals(aVHierarchy2)) {
                    String string3 = null;
                    if (aVHierarchy2 != null) {
                        string3 = aVHierarchy2.getName();
                    }
                }
            }
            this.setHierarchy(aVHierarchy);
        }
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    protected void setHierarchy(Object object) {
        this.removeAllElements();
        boolean bl = this.isValid();
        this.valid = false;
        HierarchyLevel[] hierarchyLevelArray = null;
        Hierarchy hierarchy = null;
        if (object != null) {
            AbstractChildDBObject abstractChildDBObject;
            if (object instanceof Hierarchy) {
                hierarchy = (Hierarchy)object;
            } else if (object instanceof AVHierarchy) {
                abstractChildDBObject = (AVHierarchy)object;
                hierarchy = abstractChildDBObject.getHierarchy();
            }
            abstractChildDBObject = new DimensionLevel(hierarchy.getDimension(), "\"ALL\"");
            HierarchyLevel hierarchyLevel = new HierarchyLevel(hierarchy, (DimensionLevel)abstractChildDBObject);
            this.addElement(hierarchyLevel);
            for (HierarchyLevel hierarchyLevel2 : hierarchyLevelArray = hierarchy.getHierarchyLevels()) {
                this.addElement(hierarchyLevel2);
            }
            if (hierarchyLevelArray.length > 0) {
                this.valid = true;
                this.setValue(hierarchyLevelArray[0]);
                this.setVisible(true);
            }
        }
        if (bl != this.isValid()) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid()));
        }
    }

    private Object getHierarchyLevel() {
        return this.getSelectedElement();
    }

    @Override
    public Object getValue(String string) {
        Object object = this.getHierarchyLevel();
        if (object instanceof HierarchyLevel) {
            HierarchyLevel hierarchyLevel = (HierarchyLevel)object;
            if (hierarchyLevel != null) {
                DimensionLevel dimensionLevel = hierarchyLevel.getLevel();
                if (string.equalsIgnoreCase(this.getName())) {
                    return dimensionLevel;
                }
                if (string.equalsIgnoreCase(this.getType().toString())) {
                    return dimensionLevel;
                }
                return dimensionLevel.toString();
            }
        } else if (object instanceof String) {
            return String.valueOf(object);
        }
        return "";
    }

    @Override
    public Object getValue() {
        return this.getHierarchyLevel();
    }

    @Override
    public String getExpression() {
        String string = null;
        if (this.getHierarchyLevel() == null) {
            return string;
        }
        Object object = this.getHierarchyLevel();
        if (object instanceof HierarchyLevel) {
            HierarchyLevel hierarchyLevel = (HierarchyLevel)object;
            if (this.getExpressionProperty() != null) {
                if (this.getExpressionProperty().equals(LEVEL_PROPERTY)) {
                    string = hierarchyLevel.getLevelName();
                } else if (this.getExpressionProperty().equals(DIMENSION_PROPERTY)) {
                    string = hierarchyLevel.getHierarchyDimension().getName();
                }
            } else {
                string = hierarchyLevel.getName();
            }
        } else if (object instanceof String) {
            string = String.valueOf(object);
        }
        return this.getObjectExternalName(string);
    }

    @Override
    public String getExpression(String string) {
        String string2 = null;
        Object object = this.getHierarchyLevel();
        if (object != null) {
            if (object instanceof HierarchyLevel) {
                HierarchyLevel hierarchyLevel = (HierarchyLevel)object;
                string2 = string != null && string.equalsIgnoreCase("quoted") ? "'" + hierarchyLevel.getHierarchyLevelName() + "'" : this.getExpression();
            } else if (object instanceof String) {
                string2 = this.getObjectExternalName(String.valueOf(object));
            }
        }
        return string2;
    }

    @Override
    public String getDefault() {
        return "dimension.level";
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public boolean setValue(Object object) {
        Hierarchy hierarchy = null;
        Object object2 = this.getSelectedElement();
        if (object2 != null && object2 instanceof HierarchyLevel) {
            hierarchy = ((HierarchyLevel)this.getSelectedElement()).getHierarchy();
        }
        if (object instanceof ParseNode && hierarchy != null) {
            String string;
            HierarchyLevel hierarchyLevel;
            ParseNode parseNode = (ParseNode)object;
            String string2 = hierarchy.getSchema().getName();
            IdentifierElement identifierElement = new IdentifierElement(parseNode.getValue());
            int n = 1;
            if (identifierElement.get(0).equals(string2)) {
                ++n;
            }
            if (identifierElement.getCount() == 1) {
                n = 0;
            }
            if ((hierarchyLevel = hierarchy.findHierarchyLevelForLevel(string = identifierElement.get(n))) != null) {
                return super.setValue(hierarchyLevel);
            }
            if (string.equalsIgnoreCase(ALL)) {
                return this.setValue(ALL);
            }
            return false;
        }
        if (object instanceof String) {
            if (object.equals(ALL)) {
                return this.setValue(ALL);
            }
            String string = (String)object;
            if (hierarchy != null) {
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getID().equals(string)) continue;
                    return super.setValue(hierarchyLevel);
                }
            }
        }
        return super.setValue(object);
    }

    private boolean setValue(String string) {
        Object object;
        Object object2;
        Hierarchy hierarchy = null;
        TemplateHyperParam templateHyperParam = this.getBaseTemplateHyperView().getHyperParamForType("hierarchy");
        if (templateHyperParam instanceof TemplateHyperParamHierarchy) {
            object2 = (TemplateHyperParamHierarchy)templateHyperParam;
            object = ((TemplateHyperParamHierarchy)object2).getValue();
            if (object instanceof Hierarchy) {
                hierarchy = (Hierarchy)object;
            }
            if (object instanceof AVHierarchy) {
                AVHierarchy aVHierarchy = (AVHierarchy)object;
                hierarchy = aVHierarchy.getHierarchy();
            }
        }
        if (string.equalsIgnoreCase(ALL)) {
            object2 = new DimensionLevel(hierarchy.getDimension(), "\"ALL\"");
            object = new HierarchyLevel(hierarchy, (DimensionLevel)object2);
            return super.setValue(object);
        }
        return super.setValue(string);
    }
}

