/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParamCombo;

public class TemplateHyperParamHierarchy
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchy.class.getName());
    private AVDimensionality hAVDimensionality;
    private AttributeDimension hDimension;
    private static final String DEFAULT_VALUE = "dimension.hierarchy";
    private boolean isValid;
    private static final ParseNode pattern = new ParseNode("hierarchy", HCSSyntaxType.HIERARCHY.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamHierarchy() {
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return listCellRenderer.getListCellRendererComponent(jList, TemplateHyperParamHierarchy.this.uiValue(object), n, bl, bl2);
            }
        });
    }

    private String uiValue(Object object) {
        if (object != null) {
            if (object instanceof Hierarchy) {
                Hierarchy hierarchy = (Hierarchy)object;
                return hierarchy.getName();
            }
            if (object instanceof AVHierarchy) {
                AVHierarchy aVHierarchy = (AVHierarchy)object;
                return aVHierarchy.getHierarchyAlias();
            }
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        if (this.getSelectedElement() != null) {
            return this.hyperCombo.getFontMetrics(this.hyperCombo.getFont()).stringWidth(this.uiValue(this.getSelectedElement()));
        }
        return 100;
    }

    @Override
    public String getErrorMessage() {
        return HCSArb.getString("EXPRESSION_EDITOR_ERROR_NO_HIERARCHY");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (!"VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName())) {
            AVDimensionality aVDimensionality;
            if (object instanceof AttributeDimension) {
                AttributeDimension attributeDimension = (AttributeDimension)object;
                if (!attributeDimension.equals(this.hDimension)) {
                    this.setDimension(attributeDimension);
                }
            } else if (object instanceof AVDimensionality && !(aVDimensionality = (AVDimensionality)object).equals(this.hAVDimensionality)) {
                this.setDimension(aVDimensionality);
            }
        }
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    private void setDimension(Object object) {
        if (object instanceof AttributeDimension) {
            AttributeDimension attributeDimension = (AttributeDimension)object;
            this.hAVDimensionality = null;
            if (!attributeDimension.equals(this.hDimension)) {
                boolean bl = this.isValid;
                AttributeDimension attributeDimension2 = this.hDimension;
                this.removeAllElements();
                this.hDimension = attributeDimension;
                HCSSchema hCSSchema = (HCSSchema)attributeDimension.getSchema();
                List<Hierarchy> list = hCSSchema.getHierarchies(attributeDimension);
                ArrayList<NamedObject> arrayList = new ArrayList<NamedObject>(list);
                this.addHierarchies(null, arrayList, attributeDimension2, bl);
            }
        } else if (object instanceof AVDimensionality) {
            AVDimensionality aVDimensionality = (AVDimensionality)object;
            this.hDimension = null;
            if (!aVDimensionality.equals(this.hAVDimensionality)) {
                boolean bl = this.isValid;
                AVDimensionality aVDimensionality2 = this.hAVDimensionality;
                this.removeAllElements();
                this.hAVDimensionality = aVDimensionality;
                AnalyticView analyticView = this.getTemplateContext().getAV();
                AVHierarchy aVHierarchy = this.getTemplateContext().getAVHierarchy();
                AVHierarchy[] aVHierarchyArray = analyticView.findDimensionalityForAlias(aVDimensionality.getDimensionAlias()).getHierarchies();
                if (aVHierarchy != null) {
                    aVHierarchyArray = new AVHierarchy[]{aVHierarchy};
                }
                ArrayList<NamedObject> arrayList = new ArrayList<NamedObject>(Arrays.asList(aVHierarchyArray));
                AVHierarchy aVHierarchy2 = null;
                AVDimensionality aVDimensionality3 = this.getTemplateContext().getTemplateMetadata().getBaseDimensionality();
                if (aVDimensionality3 != null && aVHierarchy == null) {
                    for (AVHierarchy aVHierarchy3 : aVDimensionality3.getHierarchies()) {
                        if (!aVHierarchy3.isHierarchyDefault()) continue;
                        aVHierarchy2 = aVHierarchy3;
                    }
                }
                this.addHierarchies(aVHierarchy2, arrayList, aVDimensionality2, bl);
            }
        }
    }

    private void addHierarchies(NamedObject namedObject, List<NamedObject> list, Object object, boolean bl) {
        if (namedObject != null && namedObject.getName().length() > 0) {
            this.addElement(namedObject);
            this.isValid = true;
            for (NamedObject namedObject2 : list) {
                if (namedObject2.equals(namedObject)) continue;
                this.addElement(namedObject2);
            }
        } else {
            for (NamedObject namedObject3 : list) {
                this.addElement(namedObject3);
                this.isValid = true;
            }
        }
        if (object != null && bl != this.isValid || !this.isValid) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "VALID_PROPERTY", bl, this.isValid));
        }
    }

    private Object getHierarchy() {
        return this.getSelectedElement();
    }

    @Override
    public Object getValue() {
        return this.getHierarchy();
    }

    @Override
    public String getExpression() {
        String string = "";
        if (this.getTemplateContext().isAV()) {
            AVHierarchy aVHierarchy = (AVHierarchy)this.getHierarchy();
            String string2 = aVHierarchy.getHierarchyAlias();
            AVDimensionality aVDimensionality = (AVDimensionality)aVHierarchy.getParent();
            String string3 = aVDimensionality.getDimensionAlias();
            string = this.getExprFromDimensionality(string3, string2);
        } else {
            Hierarchy hierarchy = (Hierarchy)this.getHierarchy();
            String string4 = hierarchy.getName();
            String string5 = hierarchy.getDimensionName();
            string = this.getExprFromDimensionality(string5, string4);
        }
        return string;
    }

    private String getExprFromDimensionality(String string, String string2) {
        return String.format("%s.%s", this.getObjectExternalName(string), this.getObjectExternalName(string2));
    }

    @Override
    public String getDefault() {
        return DEFAULT_VALUE;
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode && this.hDimension != null) {
            ParseNode parseNode = (ParseNode)object;
            HCSSchema hCSSchema = (HCSSchema)this.hDimension.getSchema();
            String string = this.getIdentifier(parseNode, 0);
            String string2 = this.getIdentifier(parseNode, 1);
            AttributeDimension attributeDimension = hCSSchema.findDimension(string);
            Hierarchy hierarchy = hCSSchema.findHierarchy(string2);
            return this.setNamedObject(attributeDimension, hierarchy);
        }
        if (object instanceof ParseNode && this.hAVDimensionality != null) {
            ParseNode parseNode = (ParseNode)object;
            AnalyticView analyticView = this.getTemplateContext().getAV();
            String string = this.getIdentifier(parseNode, 0);
            String string3 = this.getIdentifier(parseNode, 1);
            AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string);
            AVHierarchy aVHierarchy = aVDimensionality.findHierarchyByAlias(string3);
            return this.setNamedObject(aVDimensionality, aVHierarchy);
        }
        if (this.hDimension != null) {
            HCSSchema hCSSchema = (HCSSchema)this.hDimension.getSchema();
            Hierarchy hierarchy = hCSSchema.findHierarchy(String.valueOf(object));
            return super.setValue(hierarchy);
        }
        if (this.hAVDimensionality != null) {
            AnalyticView analyticView = this.getTemplateContext().getAV();
            String string = this.hAVDimensionality.getDimensionAlias();
            AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string);
            AVHierarchy aVHierarchy = aVDimensionality.findHierarchyByAlias(String.valueOf(object));
            return super.setValue(aVHierarchy);
        }
        return false;
    }

    private boolean setNamedObject(NamedObject namedObject, NamedObject namedObject2) {
        if (namedObject != null) {
            this.setDimension(namedObject);
            return super.setValue(namedObject2);
        }
        return false;
    }

    private String getIdentifier(ParseNode parseNode, int n) {
        IdentifierElement identifierElement = new IdentifierElement(parseNode.getValue());
        String string = null;
        if (identifierElement.getCount() == 2) {
            string = identifierElement.get(n);
        }
        return string;
    }
}

