/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Dimension;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.syntaxbuilder.qdr.QDRPanel;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperParamFinder;
import oracle.hcs.templates.templateview.TemplateJTree;
import oracle.hcs.util.Resources;

public class TemplateHyperContextImpl
implements TemplateHyperContext {
    private TemplateJTree templateTree;
    private TemplateHyperParamFinder finder;
    private Connection conn;
    private TemplateHyperContext.ResizeMode resizeMode;
    private Resources resources;

    public TemplateHyperContextImpl(Connection connection, Resources resources, TemplateHyperContext.ResizeMode resizeMode) {
        this.conn = connection;
        this.resizeMode = resizeMode;
        this.resources = resources;
    }

    public TemplateHyperContextImpl(Connection connection, Resources resources) {
        this(connection, resources, TemplateHyperContext.ResizeMode.LEGACY);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public TemplateHyperParamFinder getTemplateHyperParamFinder() {
        return this.finder;
    }

    @Override
    public void setTemplateHyperParamFinder(TemplateHyperParamFinder templateHyperParamFinder) {
        this.finder = templateHyperParamFinder;
    }

    @Override
    public List<QDRData> showQDRSelector(List<QDRData> list, String string, String string2) {
        Vector<QDRData> vector = new Vector<QDRData>();
        for (QDRData qDRData : list) {
            vector.add((QDRData)qDRData.clone());
        }
        QDRPanel qDRPanel = new QDRPanel(this.conn, vector, string, string2);
        qDRPanel.setSize(300, 350);
        qDRPanel.setPreferredSize(new Dimension(300, 350));
        if (UIUtils.showPanelAsDialog((JPanel)qDRPanel, (String)HCSArb.getString("QDR_SELECTOR_TITLE"), null, (int)7)) {
            return vector;
        }
        return null;
    }

    @Override
    public boolean isTimeTemplate() {
        return false;
    }

    @Override
    public TemplateHyperContext.ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public TemplateJTree getTemplateTree() {
        return this.templateTree;
    }

    @Override
    public void setTemplateTree(TemplateJTree templateJTree) {
        this.templateTree = templateJTree;
    }
}

