/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.templateview.Member;

public class QDRData
implements ParamValue,
Cloneable {
    private String dimension;
    private Hierarchy hierarchy;
    private AVHierarchy analyticViewHier;
    public List<Member> additionalMembers;
    private String memberKey;
    private String memberDescription;
    private String memberLevelName;
    private String memberLevelKey;
    private boolean quoteMemberExpression;

    public QDRData(Hierarchy hierarchy, String string, String string2) {
        this.hierarchy = hierarchy;
        this.memberKey = string;
        this.memberDescription = string2;
        this.quoteMemberExpression = true;
        if (hierarchy != null) {
            this.dimension = hierarchy.getDimensionName();
        }
    }

    public QDRData(AVHierarchy aVHierarchy, String string, String string2) {
        Hierarchy hierarchy;
        this.analyticViewHier = aVHierarchy;
        this.memberKey = string;
        this.memberDescription = string2;
        this.quoteMemberExpression = true;
        if (aVHierarchy != null && (hierarchy = aVHierarchy.getHierarchy()) != null) {
            this.dimension = aVHierarchy.getHierarchy().getDimensionName();
            this.hierarchy = aVHierarchy.getHierarchy();
        }
    }

    public QDRData(QDRData qDRData) {
        this.setData(qDRData);
    }

    public QDRData() {
    }

    public String toString() {
        String string = null;
        if (this.memberLevelName != null) {
            string = String.format("%s.%s=%s[%s]", this.dimension, this.analyticViewHier.getHierarchyAlias(), this.memberLevelName, this.memberLevelKey);
        }
        if (this.additionalMembers != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "(null)";
            int n = 0;
            String string3 = "";
            for (Member member : this.additionalMembers) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                if (n == 0) {
                    string2 = member.getMemberLevelName();
                    string3 = String.format("%s['%s']", member.getMemberLevelName(), member.getMemberDescription());
                }
                stringBuffer.append(member);
                ++n;
            }
            if (string2.equals("ALL")) {
                string2 = String.format("\"%s\"", string2);
            }
            string = this.additionalMembers.size() == 1 ? String.format("%s.%s = %s", this.dimension, this.analyticViewHier.getHierarchyAlias(), string3) : String.format("%s.%s = %s[%s]", this.dimension, this.analyticViewHier.getHierarchyAlias(), string2, stringBuffer.toString());
        }
        return string;
    }

    public boolean isMemberSet() {
        return this.memberLevelName != null || this.additionalMembers != null;
    }

    public String getExpression() {
        String string = this.toString();
        return string;
    }

    public void setMemberKey(String string) {
        this.memberKey = string;
    }

    public String getMemberKey() {
        return this.memberKey;
    }

    public void setDimension(String string) {
        this.dimension = string;
    }

    public String getDimension() {
        return this.dimension;
    }

    public AVHierarchy getAVHierarchy() {
        return this.analyticViewHier;
    }

    public void setMemberDescription(String string) {
        this.memberDescription = string;
    }

    public String getMemberDescription() {
        return this.memberDescription;
    }

    public void setMemberLevelName(String string) {
        this.memberLevelName = string;
    }

    public String getMemberLevelName() {
        return this.memberLevelName;
    }

    public void setMemberLevelKey(String string) {
        this.memberLevelKey = string;
    }

    public String getMemberLevelKey() {
        return this.memberLevelKey;
    }

    public void setData(QDRData qDRData) {
        this.analyticViewHier = qDRData.getAVHierarchy();
        this.hierarchy = qDRData.hierarchy;
        this.additionalMembers = qDRData.additionalMembers;
        this.memberLevelName = qDRData.memberLevelName;
        this.setMemberLevelKey(qDRData.getMemberLevelKey());
        this.setDimension(qDRData.getDimension());
        this.setMemberKey(qDRData.getMemberKey());
        this.setMemberDescription(qDRData.getMemberDescription());
        this.setQuoteMemberExpression(qDRData.isQuoteMemberExpression());
    }

    public void setQuoteMemberExpression(boolean bl) {
        this.quoteMemberExpression = bl;
    }

    public boolean isQuoteMemberExpression() {
        return this.quoteMemberExpression;
    }

    public Object clone() {
        return new QDRData(this);
    }

    public boolean equals(Object object) {
        if (object instanceof QDRData) {
            QDRData qDRData = (QDRData)object;
            if (qDRData.dimension != null && qDRData.dimension.equals(this.dimension)) {
                if (this.memberKey != null && (qDRData.memberKey == this.memberKey || qDRData.memberKey.equals(this.memberKey))) {
                    return true;
                }
                if (this.additionalMembers != null && this.additionalMembers.equals(qDRData.additionalMembers)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Object getValue(String string) throws SQLException, IOException {
        if (string.equalsIgnoreCase("key")) {
            return this.memberKey;
        }
        if (string.equalsIgnoreCase("qkey")) {
            if (this.additionalMembers != null) {
                String string2 = null;
                for (Member member : this.additionalMembers) {
                    if (string2 == null) {
                        string2 = "'" + member.getMemberKey() + "'";
                        continue;
                    }
                    string2 = string2 + ", '" + member.getMemberKey() + "'";
                }
                return string2;
            }
            return "'" + this.memberKey + "'";
        }
        if (string.equalsIgnoreCase("qdesc")) {
            return "'" + this.memberDescription + "'";
        }
        return null;
    }

    public void addMember(String string, String string2, String string3, String string4) {
        if (this.additionalMembers == null) {
            this.additionalMembers = new ArrayList<Member>();
        }
        this.additionalMembers.add(new Member(string, string2, string3, string4));
    }

    public void clearMembers() {
        this.additionalMembers = null;
    }

    public List<Member> getAdditionalMembers() {
        return this.additionalMembers;
    }
}

