/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.stringexpr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.templates.stringexpr.ASTExpression;
import oracle.hcs.templates.stringexpr.ParamProperty;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.stringexpr.ParseException;
import oracle.hcs.templates.stringexpr.StringExprParser;
import oracle.hcs.templates.templateview.ItemElement;
import oracle.hcs.templates.templateview.TemplateHyperParamFactory;

public class ParamStringExpr {
    private static final Logger LOG = Logger.getLogger(ParamStringExpr.class.getName());
    private static final int EXPR_MARK_LENGTH = "$sexpr".length();
    private static ParamStringExpr INSTANCE;

    private ParamStringExpr() {
    }

    public static ParamStringExpr getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParamStringExpr();
        }
        return INSTANCE;
    }

    public String getExpression(String string, ParamValue paramValue, ParamProperty paramProperty, AVBaseMeasure aVBaseMeasure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        if (string == null) {
            return null;
        }
        string = this.evaluateStringExprs(string, paramValue, hashMap);
        String string2 = null;
        while (string != null && string.indexOf("{") >= 0) {
            string2 = string;
            int n = string.indexOf("{");
            int n2 = string.indexOf("}");
            if (n2 < 0) continue;
            String string3 = string.substring(n + 1, n2);
            String[] stringArray = TemplateHyperParamFactory.splitDefinition(string3);
            String string4 = stringArray[3];
            String string5 = stringArray[2];
            String string6 = paramProperty.getParamPropertyValue(string4, string5, aVBaseMeasure, itemElement, hashMap);
            String string7 = string;
            String string8 = string7.substring(0, n);
            if (string6 != null) {
                string = string8;
                string = string + string6;
            }
            String string9 = string7.substring(n2 + 1, string7.length());
            if (string6 != null) {
                string = string + string9;
            }
            if (n == 0 && n2 == string.length() - 1 && string6 == null) {
                string = null;
            }
            if (!string2.equals(string)) continue;
            break;
        }
        return string;
    }

    public String evaluateStringExprs(String string, ParamValue paramValue, HashMap<String, String> hashMap) throws SQLException, IOException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = -1;
        while ((n2 = string.indexOf("$sexpr")) != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            String string3 = "";
            string3 = this.evaluateStringExpr(string2, paramValue, hashMap);
            String string4 = string;
            string = string4.substring(0, n2);
            if (string3 == null) {
                if (string.isEmpty()) {
                    return null;
                }
                string3 = "";
            }
            string = string + string3;
            string = string + string4.substring(n + 2, string4.length());
        }
        return string;
    }

    private String evaluateStringExpr(String string, ParamValue paramValue, HashMap<String, String> hashMap) throws SQLException, IOException {
        String string2 = null;
        int n = EXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(EXPR_MARK_LENGTH + 1, n);
        }
        String string3 = string = string.substring(n + 1, string.length() - 2);
        try {
            ParamValue paramValue2 = StringExprParser.getParamValue();
            string3 = StringExprParser.getParseTree(string, paramValue);
            StringExprParser.setParamValue(paramValue2);
            if (string2 != null && hashMap != null) {
                hashMap.put(string2, string3);
            }
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
            string3 = String.format(" \"%s\"->%s\n", string, parseException.getMessage());
        }
        return string3;
    }

    public Object evaluateObjectExprs(String string, ParamValue paramValue) throws SQLException, IOException {
        int n;
        Object object = null;
        if (string == null) {
            return object;
        }
        int n2 = -1;
        n2 = string.indexOf("$oexpr");
        if (n2 != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            object = this.evaluateObjectExpr(string2, paramValue);
            String string3 = string;
            string = string3.substring(0, n2);
            if (object == null && string.isEmpty()) {
                return null;
            }
        }
        return object;
    }

    private Object evaluateObjectExpr(String string, ParamValue paramValue) throws SQLException, IOException {
        String string2 = null;
        Object object = null;
        int n = EXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(EXPR_MARK_LENGTH + 1, n);
        }
        string = string.substring(n + 1, string.length() - 2);
        ASTExpression aSTExpression = null;
        try {
            ParamValue paramValue2 = StringExprParser.getParamValue();
            aSTExpression = StringExprParser.getParseTreeObj(string, paramValue);
            if (aSTExpression != null) {
                object = aSTExpression.getValue();
            }
            StringExprParser.setParamValue(paramValue2);
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
        }
        return object;
    }
}

