/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.spec;

import java.util.Iterator;
import java.util.List;
import oracle.hcs.syntaxbuilder.spec.Filter;

public class FilterIterator<E>
implements Iterator<E>,
Iterable<E> {
    private Iterator<E> iterator;
    private E current;
    private boolean hasNext;
    private Filter<? super E> filter;

    public FilterIterator(List<E> list, Filter<? super E> filter) {
        if (list == null) {
            return;
        }
        this.filter = filter;
        this.iterator = list.iterator();
        this.getNext();
    }

    protected void getNext() {
        while (this.iterator.hasNext()) {
            E e = this.iterator.next();
            if (!this.filter.matches(e)) continue;
            this.current = e;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        E e = this.current;
        this.getNext();
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

